/*
 * Decompiled with CFR 0.152.
 */
package me.drex.worldmanager.gui.configure;

import com.mojang.serialization.DynamicOps;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.Optional;
import me.drex.message.api.LocalizedMessage;
import me.drex.worldmanager.gui.configure.SelectChunkGenerator;
import me.drex.worldmanager.gui.configure.SelectDimensionType;
import me.drex.worldmanager.gui.configure.SelectSeed;
import me.drex.worldmanager.save.WorldConfig;
import me.drex.worldmanager.save.WorldData;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5628;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7134;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public abstract class ConfigureWorld
extends SimpleGui {
    protected final class_2960 id;
    protected class_6880<class_2874> type;
    protected class_2794 generator;
    protected long seed;
    protected boolean tickTime;

    public ConfigureWorld(class_3222 player, class_2960 id) {
        super(class_3917.field_17326, player, false);
        this.id = id;
        this.setTitle((class_2561)LocalizedMessage.builder((String)"worldmanager.gui.configure.title").addPlaceholder("id", id.toString()).build());
        this.setupDefaults(player.method_37908().method_8503());
        this.build();
    }

    private void setupDefaults(MinecraftServer server) {
        class_5455.class_6890 frozen = server.method_30611();
        class_7225.class_7226 dimensionType = frozen.method_46762(class_7924.field_41241);
        this.type = dimensionType.method_46747(class_7134.field_37666);
        this.generator = server.method_30002().method_14178().method_12129();
        this.seed = 0L;
        this.tickTime = true;
    }

    public void build() {
        this.setSlot(0, this.builder(class_1802.field_8694, "type").setCallback(() -> new SelectDimensionType(this.player, this, type -> {
            this.type = type;
            this.build();
        }).open()));
        this.setSlot(1, this.builder(class_1802.field_8270, "generator").setCallback(() -> new SelectChunkGenerator(this.player, this, generator -> {
            this.generator = generator;
            this.build();
        }).open()));
        this.setSlot(2, this.builder(class_1802.field_8317, "seed").setCallback(() -> new SelectSeed(this.player, this, seed -> {
            this.seed = seed;
            this.build();
        }).open()));
        this.setSlot(3, this.builder(class_1802.field_8557, "tick_time").setCallback(() -> {
            this.tickTime = !this.tickTime;
            this.build();
        }));
        for (int i = 18; i < 27; ++i) {
            this.setSlot(i, this.builder(class_1802.field_8656, "confirm").setCallback(() -> {
                WorldConfig config = new WorldConfig(this.type, this.generator, this.seed, this.tickTime, new WorldData());
                this.confirm(config);
                this.close();
            }));
        }
    }

    protected abstract void confirm(WorldConfig var1);

    private GuiElementBuilder builder(class_1792 item, String id) {
        class_5455 access = this.player.method_56673();
        Optional result = class_2794.field_24746.encodeStart((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)access), (Object)this.generator).result();
        class_5250 lore = class_2561.method_43473();
        if (result.isPresent()) {
            lore = new class_5628("    ").method_32305((class_2520)result.get());
        }
        return new GuiElementBuilder(item).setName((class_2561)LocalizedMessage.builder((String)("worldmanager.gui.configure." + id + ".name")).build()).addLoreLine((class_2561)LocalizedMessage.builder((String)("worldmanager.gui.configure." + id + ".lore")).addPlaceholder("type", this.type.method_40230().map(class_5321::method_29177).map(class_2960::toString).orElse("???")).addPlaceholder("generator", this.generator.method_39301().map(class_5321::method_29177).map(class_2960::toString).orElse("???")).addPlaceholder("generator_full", (class_2561)lore).addPlaceholder("seed", (Number)this.seed).addPlaceholder("tick_time", this.tickTime).build());
    }
}

