/*
 * Decompiled with CFR 0.152.
 */
package me.drex.worldmanager.save;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import me.drex.worldmanager.save.WorldConfig;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2960;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import xyz.nucleoid.fantasy.Fantasy;
import xyz.nucleoid.fantasy.RuntimeWorldHandle;

public class WorldManagerSavedData
extends class_18 {
    private final Map<class_2960, WorldConfig> worlds;
    private final Map<class_2960, RuntimeWorldHandle> worldHandles = new HashMap<class_2960, RuntimeWorldHandle>();
    private static final Codec<WorldManagerSavedData> CODEC = Codec.unboundedMap((Codec)class_2960.field_25139, WorldConfig.CODEC).xmap(WorldManagerSavedData::new, worldManagerSavedData -> worldManagerSavedData.worlds);

    private WorldManagerSavedData() {
        this.worlds = new HashMap<class_2960, WorldConfig>();
    }

    private WorldManagerSavedData(Map<class_2960, WorldConfig> worlds) {
        this.worlds = new HashMap<class_2960, WorldConfig>(worlds);
    }

    @NotNull
    public class_2487 method_75(class_2487 compoundTag, class_7225.class_7874 provider) {
        return (class_2487)CODEC.encode((Object)this, (DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)provider), (Object)compoundTag).getOrThrow();
    }

    public static class_18.class_8645<WorldManagerSavedData> factory() {
        return new class_18.class_8645(WorldManagerSavedData::new, WorldManagerSavedData::load, null);
    }

    public static WorldManagerSavedData load(class_2487 compoundTag, class_7225.class_7874 provider) {
        return (WorldManagerSavedData)((Object)((Pair)CODEC.decode((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)provider), (Object)compoundTag).getOrThrow()).getFirst());
    }

    public static WorldManagerSavedData getSavedData(MinecraftServer server) {
        return (WorldManagerSavedData)server.method_30002().method_17983().method_17924(WorldManagerSavedData.factory(), "worldmanager");
    }

    public void loadWorlds(MinecraftServer server) {
        this.worlds.forEach((id, worldConfig) -> {
            RuntimeWorldHandle handle = Fantasy.get((MinecraftServer)server).getOrOpenPersistentWorld(id, worldConfig.toRuntimeWorldConfig());
            this.worldHandles.put((class_2960)id, handle);
        });
    }

    public void addWorld(class_2960 id, WorldConfig config, RuntimeWorldHandle handle) {
        this.worlds.put(id, config);
        this.worldHandles.put(id, handle);
        this.method_80();
    }

    public boolean removeWorld(class_2960 id) {
        WorldConfig config = this.worlds.remove(id);
        if (config != null) {
            RuntimeWorldHandle handle = this.worldHandles.remove(id);
            handle.delete();
            this.method_80();
            return true;
        }
        return false;
    }

    public WorldConfig getConfig(class_2960 id) {
        return this.worlds.get(id);
    }

    public Map<class_2960, WorldConfig> getWorlds() {
        return new HashMap<class_2960, WorldConfig>(this.worlds);
    }
}

