/*
 * Decompiled with CFR 0.152.
 */
package me.drex.worldmanager.extractor;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.stream.Stream;
import me.drex.worldmanager.command.ImportCommand;
import me.drex.worldmanager.extractor.ArchiveExtractor;
import me.drex.worldmanager.save.WorldConfig;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class FolderArchiveExtractor
implements ArchiveExtractor {
    @Override
    public boolean supports(Path path) {
        return Files.isDirectory(path, new LinkOption[0]);
    }

    @Override
    public WorldConfig extract(Path folderPath, Path targetPath, MinecraftServer server) throws CommandSyntaxException, IOException {
        Optional<Object> config = Optional.empty();
        Path root = Path.of(".", new String[0]);
        try (Stream<Path> pathStream = Files.find(folderPath, 10, (path, basicFileAttributes) -> path.getFileName().toString().equals(class_5218.field_24184.method_27423()), new FileVisitOption[0]);){
            Optional<Path> first = pathStream.findFirst();
            if (first.isPresent()) {
                Path parent = first.get().getParent();
                if (parent != null) {
                    root = parent;
                }
                config = ImportCommand.parseWorldConfig(Files.newInputStream(first.get(), new OpenOption[0]), server);
            }
        }
        if (config.isEmpty()) {
            throw ImportCommand.MISSING_LEVEL_DAT.create((Object)folderPath);
        }
        try (Stream<Path> files = Files.walk(root, new FileVisitOption[0]);){
            for (Path path2 : files.toList()) {
                Path relativize = root.relativize(path2);
                String topDir = relativize.getName(0).toString();
                if (!ImportCommand.DIMENSION_PREFIXES.contains(topDir)) continue;
                Path resolvedPath = targetPath.resolve(relativize);
                if (Files.isDirectory(path2, new LinkOption[0])) {
                    Files.createDirectories(resolvedPath, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(resolvedPath.getParent(), new FileAttribute[0]);
                InputStream inputStream = Files.newInputStream(path2, new OpenOption[0]);
                try {
                    Files.copy(inputStream, resolvedPath, StandardCopyOption.REPLACE_EXISTING);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        return (WorldConfig)config.get();
    }
}

