/*
 * Decompiled with CFR 0.152.
 */
package me.drex.worldmanager.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import me.drex.message.api.LocalizedMessage;
import me.drex.worldmanager.gui.CreateWorld;
import me.drex.worldmanager.save.WorldConfig;
import me.drex.worldmanager.save.WorldManagerSavedData;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2179;
import net.minecraft.class_2232;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import xyz.nucleoid.fantasy.Fantasy;
import xyz.nucleoid.fantasy.RuntimeWorldHandle;

public class CreateCommand {
    public static LiteralArgumentBuilder<class_2168> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"create").requires(Permissions.require((String)"worldmanager.command.worldmanager.create", (int)2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).executes(context -> {
            class_2960 id = class_2232.method_9443((CommandContext)context, (String)"id");
            class_5321 resourceKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)id);
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            class_3218 level = server.method_3847(resourceKey);
            if (level != null) {
                throw new SimpleCommandExceptionType((Message)LocalizedMessage.localized((String)"worldmanager.command.exception.world_already_exists")).create();
            }
            new CreateWorld(((class_2168)context.getSource()).method_9207(), id).open();
            return 1;
        })).then(class_2170.method_9244((String)"nbt", (ArgumentType)class_2179.method_9284()).executes(context -> {
            class_2960 id = class_2232.method_9443((CommandContext)context, (String)"id");
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            CreateCommand.validLevelId(id, server);
            class_2487 tag = class_2179.method_9285((CommandContext)context, (String)"nbt");
            WorldConfig config = (WorldConfig)((Pair)WorldConfig.CODEC.decode((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)server.method_30611()), (Object)tag).getOrThrow(s -> new SimpleCommandExceptionType((Message)class_2561.method_43470((String)s)).create())).getFirst();
            Fantasy fantasy = Fantasy.get((MinecraftServer)server);
            RuntimeWorldHandle handle = fantasy.getOrOpenPersistentWorld(id, config.toRuntimeWorldConfig());
            WorldManagerSavedData savedData = WorldManagerSavedData.getSavedData(server);
            savedData.addWorld(id, config, handle);
            ((class_2168)context.getSource()).method_9226(() -> LocalizedMessage.builder((String)"worldmanager.command.create").addPlaceholder("id", id.toString()).build(), false);
            return 1;
        })));
    }

    public static void validLevelId(class_2960 id, MinecraftServer server) throws CommandSyntaxException {
        class_5321 resourceKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)id);
        class_3218 level = server.method_3847(resourceKey);
        if (level != null) {
            throw new SimpleCommandExceptionType((Message)LocalizedMessage.localized((String)"worldmanager.command.exception.world_already_exists")).create();
        }
    }
}

