/*
 * Decompiled with CFR 0.152.
 */
package me.drex.worldmanager.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import me.drex.message.api.LocalizedMessage;
import me.drex.worldmanager.command.WorldManagerCommand;
import me.drex.worldmanager.save.Location;
import me.drex.worldmanager.save.WorldConfig;
import me.drex.worldmanager.save.WorldLocation;
import me.drex.worldmanager.save.WorldManagerSavedData;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class SpawnCommand {
    public static LiteralArgumentBuilder<class_2168> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"spawn").requires(Permissions.require((String)"worldmanager.command.worldmanager.spawn", (int)2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).suggests(WorldManagerCommand.WORLD_SUGGESTIONS).executes(context -> SpawnCommand.spawn((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"id"), List.of(((class_2168)context.getSource()).method_9207())))).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).executes(context -> SpawnCommand.spawn((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"id"), class_2186.method_9312((CommandContext)context, (String)"targets")))));
    }

    public static int spawn(class_2168 source, class_2960 id, Collection<class_3222> targets) throws CommandSyntaxException {
        class_5321 resourceKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)id);
        MinecraftServer server = source.method_9211();
        WorldManagerSavedData savedData = WorldManagerSavedData.getSavedData(server);
        WorldConfig config = savedData.getConfig(id);
        class_3218 serverLevel = source.method_9211().method_3847(resourceKey);
        if (serverLevel == null) {
            throw WorldManagerCommand.UNKNOWN_WORLD.create();
        }
        for (class_3222 player : targets) {
            SpawnCommand.spawn(player, config, id);
        }
        source.method_9226(() -> LocalizedMessage.builder((String)"worldmanager.command.spawn").addPlaceholder("id", id.toString()).build(), false);
        return 1;
    }

    public static boolean spawn(class_3222 player, WorldConfig config, class_2960 id) {
        class_5321 resourceKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)id);
        class_3218 serverLevel = player.method_37908().method_8503().method_3847(resourceKey);
        if (serverLevel == null) {
            return false;
        }
        Optional<Location> spawnLocation = Optional.empty();
        if (config != null) {
            spawnLocation = config.data.spawnLocation;
        }
        WorldLocation worldLocation = spawnLocation.map(location -> location.toWorldLocation(serverLevel)).orElseGet(() -> WorldLocation.findSpawn(serverLevel, (class_1297)player));
        worldLocation.teleport((class_1297)player);
        return true;
    }
}

