/*
 * Decompiled with CFR 0.152.
 */
package me.drex.worldmanager.extractor;

import com.github.junrar.Archive;
import com.github.junrar.exception.RarException;
import com.github.junrar.exception.UnsupportedRarV5Exception;
import com.github.junrar.rarfile.FileHeader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import me.drex.worldmanager.command.ImportCommand;
import me.drex.worldmanager.extractor.ArchiveExtractor;
import me.drex.worldmanager.save.WorldConfig;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.FilenameUtils;

public class RarArchiveExtractor
implements ArchiveExtractor {
    @Override
    public boolean supports(Path path) {
        String extension = FilenameUtils.getExtension((String)path.toString());
        return extension.equalsIgnoreCase("rar");
    }

    @Override
    public WorldConfig extract(Path rarPath, Path targetPath, MinecraftServer server) throws CommandSyntaxException, IOException {
        Optional<Object> config = Optional.empty();
        try {
            Archive archive = new Archive(Files.newInputStream(rarPath, new OpenOption[0]));
            Path root = Path.of(".", new String[0]);
            List fileHeaders = archive.getFileHeaders();
            for (FileHeader fileHeader : fileHeaders) {
                String fileName = fileHeader.getFileName().replace('\\', '/');
                Path path = Paths.get(fileName, new String[0]);
                if (!path.getFileName().toString().equals(class_5218.field_24184.method_27423())) continue;
                Path parent = path.getParent();
                if (parent != null) {
                    root = parent;
                }
                try (InputStream is = archive.getInputStream(fileHeader);){
                    config = ImportCommand.parseWorldConfig(is, server);
                    break;
                }
            }
            if (config.isEmpty()) {
                throw ImportCommand.MISSING_LEVEL_DAT.create((Object)rarPath);
            }
            for (FileHeader fileHeader : fileHeaders) {
                Path entryPath = Paths.get(fileHeader.getFileName().replace('\\', '/'), new String[0]);
                Path relativize = root.relativize(entryPath);
                String topDir = relativize.getName(0).toString();
                if (!ImportCommand.DIMENSION_PREFIXES.contains(topDir)) continue;
                Path resolvedPath = targetPath.resolve(relativize);
                if (fileHeader.isDirectory()) {
                    Files.createDirectories(resolvedPath, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(resolvedPath.getParent(), new FileAttribute[0]);
                InputStream inputStream = archive.getInputStream(fileHeader);
                try {
                    Files.copy(inputStream, resolvedPath, StandardCopyOption.REPLACE_EXISTING);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            return (WorldConfig)config.get();
        }
        catch (RarException e) {
            if (e instanceof UnsupportedRarV5Exception) {
                throw ImportCommand.RAR5.create((Object)rarPath);
            }
            throw new IOException(e);
        }
    }
}

