/*
 * Decompiled with CFR 0.152.
 */
package me.drex.worldmanager.extractor;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import me.drex.worldmanager.command.ImportCommand;
import me.drex.worldmanager.extractor.ArchiveExtractor;
import me.drex.worldmanager.save.WorldConfig;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.FilenameUtils;

public class ZipArchiveExtractor
implements ArchiveExtractor {
    @Override
    public boolean supports(Path path) {
        String extension = FilenameUtils.getExtension((String)path.toString());
        return extension.equalsIgnoreCase("zip");
    }

    @Override
    public WorldConfig extract(Path zipPath, Path targetPath, MinecraftServer server) throws CommandSyntaxException, IOException {
        Optional<Object> config = Optional.empty();
        try (ZipFile zipFile = new ZipFile(zipPath.toFile());){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            Path root = Path.of(".", new String[0]);
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                Path path = Path.of(zipEntry.getName(), new String[0]);
                if (!path.getFileName().toString().equals(class_5218.field_24184.method_27423())) continue;
                Path parent = path.getParent();
                if (parent != null) {
                    root = parent;
                }
                try (InputStream is = zipFile.getInputStream(zipEntry);){
                    config = ImportCommand.parseWorldConfig(is, server);
                    break;
                }
            }
            if (config.isEmpty()) {
                throw ImportCommand.MISSING_LEVEL_DAT.create((Object)zipPath);
            }
            Iterator<? extends ZipEntry> iterator = zipFile.entries().asIterator();
            while (iterator.hasNext()) {
                ZipEntry zipEntry = iterator.next();
                Path entryPath = Paths.get(zipEntry.getName(), new String[0]);
                Path relativize = root.relativize(entryPath);
                String topDir = relativize.getName(0).toString();
                if (!ImportCommand.DIMENSION_PREFIXES.contains(topDir)) continue;
                Path resolvedPath = targetPath.resolve(relativize);
                if (zipEntry.isDirectory()) {
                    Files.createDirectories(resolvedPath, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(resolvedPath.getParent(), new FileAttribute[0]);
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                try {
                    Files.copy(inputStream, resolvedPath, StandardCopyOption.REPLACE_EXISTING);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        return (WorldConfig)config.get();
    }
}

