/*
 * Decompiled with CFR 0.152.
 */
package me.drex.worldmanager.gui.util;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.List;
import me.drex.message.api.LocalizedMessage;
import me.drex.worldmanager.gui.util.GuiElements;
import net.minecraft.class_1707;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;

public abstract class PagedGui<T>
extends SimpleGui {
    private static final int WIDTH = 9;
    protected final SimpleGui previousGui;
    private int page = 0;

    public PagedGui(class_3917<class_1707> menuType, class_3222 player) {
        this(menuType, player, null);
    }

    public PagedGui(class_3917<class_1707> menuType, class_3222 player, SimpleGui previousGui) {
        super(menuType, player, false);
        this.previousGui = previousGui;
        assert (this.height > 1);
        assert (this.width == 9);
    }

    public void build() {
        List<T> elements = this.elements();
        int slots = this.getVirtualSize() - 9;
        for (int slotIndex = 0; slotIndex < slots; ++slotIndex) {
            int elementIndex = this.page * slots + slotIndex;
            if (elementIndex >= elements.size()) {
                this.clearSlot(slotIndex);
                continue;
            }
            T element = elements.get(elementIndex);
            this.setSlot(slotIndex, (GuiElementBuilderInterface)this.toGuiElement(element));
        }
        this.setSlot(slots, new GuiElementBuilder(class_1802.field_8575).setSkullOwner("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYmQ2OWUwNmU1ZGFkZmQ4NGU1ZjNkMWMyMTA2M2YyNTUzYjJmYTk0NWVlMWQ0ZDcxNTJmZGM1NDI1YmMxMmE5In19fQ==").setName((class_2561)LocalizedMessage.localized((String)"worldmanager.gui.paged.previous_page.name")).setCallback(() -> {
            this.page = Math.max(this.page - 1, 0);
            this.build();
        }));
        this.setSlot(slots + 4, (GuiElementBuilderInterface)GuiElements.back(this.previousGui));
        this.setSlot(slots + 8, new GuiElementBuilder(class_1802.field_8575).setSkullOwner("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTliZjMyOTJlMTI2YTEwNWI1NGViYTcxM2FhMWIxNTJkNTQxYTFkODkzODgyOWM1NjM2NGQxNzhlZDIyYmYifX19").setName((class_2561)LocalizedMessage.localized((String)"worldmanager.gui.paged.next_page.name")).setCallback(() -> {
            int maxPage = (elements.size() - 1) / slots;
            this.page = Math.min(this.page + 1, maxPage);
            this.build();
        }));
    }

    protected abstract List<T> elements();

    protected abstract GuiElementBuilder toGuiElement(T var1);
}

