/*
 * Decompiled with CFR 0.152.
 */
package me.drex.worldmanager.extractor;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import me.drex.worldmanager.command.ImportCommand;
import me.drex.worldmanager.extractor.ArchiveExtractor;
import me.drex.worldmanager.save.WorldConfig;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FilenameUtils;

public class TarGzArchiveExtractor
implements ArchiveExtractor {
    @Override
    public boolean supports(Path path) {
        String name = FilenameUtils.getName((String)path.toString().toLowerCase());
        return name.endsWith(".tar.gz") || name.endsWith(".tgz");
    }

    @Override
    public WorldConfig extract(Path tarGzPath, Path targetPath, MinecraftServer server) throws CommandSyntaxException, IOException {
        Optional<Object> config = Optional.empty();
        try (InputStream fi = Files.newInputStream(tarGzPath, new OpenOption[0]);
             BufferedInputStream bi = new BufferedInputStream(fi);
             GzipCompressorInputStream gzi = new GzipCompressorInputStream((InputStream)bi);
             TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)gzi);){
            TarArchiveEntry entry;
            Path root = Path.of(".", new String[0]);
            while ((entry = tarIn.getNextEntry()) != null) {
                Path entryPath = Paths.get(entry.getName(), new String[0]);
                if (!entryPath.getFileName().toString().equals(class_5218.field_24184.method_27423())) continue;
                Path parent = entryPath.getParent();
                if (parent != null) {
                    root = parent;
                }
                config = ImportCommand.parseWorldConfig((InputStream)tarIn, server);
                break;
            }
            if (config.isEmpty()) {
                throw ImportCommand.MISSING_LEVEL_DAT.create((Object)tarGzPath);
            }
            try (InputStream fi2 = Files.newInputStream(tarGzPath, new OpenOption[0]);
                 BufferedInputStream bi2 = new BufferedInputStream(fi2);
                 GzipCompressorInputStream gzi2 = new GzipCompressorInputStream((InputStream)bi2);
                 TarArchiveInputStream tarIn2 = new TarArchiveInputStream((InputStream)gzi2);){
                while ((entry = tarIn2.getNextEntry()) != null) {
                    String topDir;
                    Path entryPath = Paths.get(entry.getName(), new String[0]);
                    Path relativize = root.relativize(entryPath);
                    if (relativize.getNameCount() == 0 || !ImportCommand.DIMENSION_PREFIXES.contains(topDir = relativize.getName(0).toString())) continue;
                    Path resolvedPath = targetPath.resolve(relativize);
                    if (entry.isDirectory()) {
                        Files.createDirectories(resolvedPath, new FileAttribute[0]);
                        continue;
                    }
                    Files.createDirectories(resolvedPath.getParent(), new FileAttribute[0]);
                    Files.copy((InputStream)tarIn2, resolvedPath, StandardCopyOption.REPLACE_EXISTING);
                }
            }
        }
        return (WorldConfig)config.get();
    }
}

