package net.robofox.copperrails.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.class_1313;
import net.minecraft.class_1688;
import net.minecraft.class_2241;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2442;
import net.minecraft.class_2680;
import net.minecraft.class_2768;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.robofox.copperrails.CopperRails;
import net.robofox.copperrails.CopperRailsConfig;
import net.robofox.copperrails.block.ModBlocks;
import net.robofox.copperrails.block.custom.GenericCopperRailBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(class_1688.class)
public abstract class AbstractMinecartMixin {

	/**
	 * Mixin to replace check if minecart should be propelled (if rail is powering rail)
	 */
	@Redirect(
			method = "moveAlongTrack",
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/world/level/block/state/BlockState;is(Lnet/minecraft/world/level/block/Block;)Z"))
	public boolean isPoweringRail(class_2680 state, class_2248 block) {
		// This code is injected into the start of AbstractMinecartEntity.moveAlongTrack()V
		if (block == class_2246.field_10425) {
			class_2248 unknownRail = state.method_26204();
			// We want to check if this is a powering rail
			return (unknownRail instanceof GenericCopperRailBlock || unknownRail == class_2246.field_10425);
		} else {
			CopperRails.LOGGER.warn("isOf() Mixin called with something else than Blocks.POWERED_RAIL");
			return state.method_27852(block);
		}
	}

	@Unique
	public double getMaxRailSpeed(class_2680 blockState) {
		class_2248 block = blockState.method_26204();
		if (block == ModBlocks.COPPER_RAIL || block == ModBlocks.WAXED_COPPER_RAIL) {
			return CopperRailsConfig.COPPER_SPEED;
		} else if (block == ModBlocks.EXPOSED_COPPER_RAIL || block == ModBlocks.WAXED_EXPOSED_COPPER_RAIL) {
			return CopperRailsConfig.EXPOSED_COPPER_SPEED;
		} else if (block == ModBlocks.WEATHERED_COPPER_RAIL || block == ModBlocks.WAXED_WEATHERED_COPPER_RAIL) {
			return CopperRailsConfig.WEATHERED_COPPER_SPEED;
		} else if (block == ModBlocks.OXIDIZED_COPPER_RAIL || block == ModBlocks.WAXED_OXIDIZED_COPPER_RAIL) {
			return CopperRailsConfig.OXIDIZED_COPPER_SPEED;
		} else if (block == class_2246.field_10425) {
			return CopperRailsConfig.GOLD_SPEED;
		} else {
			// All other rails not boosting minecarts
			return CopperRailsConfig.NORMAL_RAIL_SPEED;
		}
	}

	/**
	 * @author Robofox
	 * @reason Rewrite all getMaxSpeed (very short) to increase max speed
	 */
	@Overwrite
	public double getMaxSpeed() {
		class_1688 minecart = (class_1688) (Object) this;
		return (minecart.method_5799() ? CopperRailsConfig.NORMAL_RAIL_SPEED / 2.0 : CopperRailsConfig.NORMAL_RAIL_SPEED);
	}

	@Unique
	private double convergeAbs(double speed, double targetSpeed) {
		if (Math.abs(speed) > targetSpeed) {
			return Math.signum(speed) * Math.max(Math.abs(speed) * 0.7, targetSpeed);
		} else {
			return speed;
		}
	}

	@Redirect(
			method = "moveAlongTrack",
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/world/entity/vehicle/AbstractMinecart;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V",
					ordinal = 9))
	public void setVelocityClamp(class_1688 minecart, class_243 velocity) {
		double maxSpeed = getMaxRailSpeed(minecart.method_37908().method_8320(minecart.method_24515()));
		minecart.method_18800(convergeAbs(velocity.field_1352, maxSpeed), velocity.field_1351, convergeAbs(velocity.field_1350, maxSpeed));
	}

	@Redirect(
			method = "moveAlongTrack",
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/world/entity/vehicle/AbstractMinecart;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V",
					ordinal = 0))
	public void setVelocityAscendingEast(class_1688 minecart, class_243 velocity_adder) {
		class_243 velocity = minecart.method_18798();
		double v_x = velocity_adder.field_1352;
		double v_y = velocity_adder.field_1351;
		double v_z = velocity_adder.field_1350;
		if (velocity.field_1352 > CopperRailsConfig.MAX_ASCENDING_SPEED) {
			v_x = CopperRailsConfig.MAX_ASCENDING_SPEED;
		}
		minecart.method_18800(v_x, v_y, v_z);
	}

	@Redirect(
			method = "moveAlongTrack",
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/world/entity/vehicle/AbstractMinecart;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V",
					ordinal = 1))
	public void setVelocityAscendingWest(class_1688 minecart, class_243 velocity_adder) {
		class_243 velocity = minecart.method_18798();
		double v_x = velocity_adder.field_1352;
		double v_y = velocity_adder.field_1351;
		double v_z = velocity_adder.field_1350;
		if (velocity.field_1352 < - CopperRailsConfig.MAX_ASCENDING_SPEED) {
			v_x = - CopperRailsConfig.MAX_ASCENDING_SPEED;
		}
		minecart.method_18800(v_x, v_y, v_z);
	}

	@Redirect(
			method = "moveAlongTrack",
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/world/entity/vehicle/AbstractMinecart;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V",
					ordinal = 2))
	public void setVelocityAscendingNorth(class_1688 minecart, class_243 velocity_adder) {
		class_243 velocity = minecart.method_18798();
		double v_x = velocity_adder.field_1352;
		double v_y = velocity_adder.field_1351;
		double v_z = velocity_adder.field_1350;
		if (velocity.field_1350 < - CopperRailsConfig.MAX_ASCENDING_SPEED) {
			v_z = - CopperRailsConfig.MAX_ASCENDING_SPEED;
		}
		minecart.method_18800(v_x, v_y, v_z);
	}

	@Redirect(
			method = "moveAlongTrack",
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/world/entity/vehicle/AbstractMinecart;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V",
					ordinal = 3))
	public void setVelocityAscendingSouth(class_1688 minecart, class_243 velocity_adder) {
		class_243 velocity = minecart.method_18798();
		double v_x = velocity_adder.field_1352;
		double v_y = velocity_adder.field_1351;
		double v_z = velocity_adder.field_1350;
		if (velocity.field_1350 > CopperRailsConfig.MAX_ASCENDING_SPEED) {
			v_z = CopperRailsConfig.MAX_ASCENDING_SPEED;
		}
		minecart.method_18800(v_x, v_y, v_z);
	}

	/**
	 * Mixin to implement rail direction switching for crossing rail blocks
	 */
	@Unique
	private class_2768 getRailShape(class_2680 blockState, class_2769<class_2768> property) {
		class_2768 railShape = blockState.method_11654(property);
		if (blockState.method_27852(ModBlocks.RAIL_CROSSING)) {
			boolean isPowered = blockState.method_11654(class_2442.field_11364);
			if (isPowered) {
				switch (railShape) {
					case field_12665:
						return class_2768.field_12674;
					case field_12674:
						return class_2768.field_12665;
					default:
						CopperRails.LOGGER.error("Crossing rail has invalid shape");
				}
			}
		}
		return railShape;
	}

	@Redirect(
			method = "moveAlongTrack",
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/world/level/block/state/BlockState;getValue(Lnet/minecraft/world/level/block/state/properties/Property;)Ljava/lang/Comparable;",
					ordinal = 1))
	public <T extends Comparable<T>> T getMoveAlongTrackMixin(class_2680 blockState, class_2769<class_2768> property) {
		return (T) getRailShape(blockState, property);
	}
	@Redirect(
			method = "getPosOffs",
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/world/level/block/state/BlockState;getValue(Lnet/minecraft/world/level/block/state/properties/Property;)Ljava/lang/Comparable;",
					ordinal = 0))
	public <T extends Comparable<T>> T getSnapPositionToRailWithOffsetMixin(class_2680 blockState, class_2769<class_2768> property) {
		return (T) getRailShape(blockState, property);
	}
	@Redirect(
			method = "getPos",
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/world/level/block/state/BlockState;getValue(Lnet/minecraft/world/level/block/state/properties/Property;)Ljava/lang/Comparable;",
					ordinal = 0))
	public <T extends Comparable<T>> T getSnapPositionToRailMixin(class_2680 blockState, class_2769<class_2768> property) {
		return (T) getRailShape(blockState, property);
	}

	@Redirect(
			method = "moveAlongTrack",
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/world/entity/vehicle/AbstractMinecart;move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V"
			)
	)
	public void accurateCollisionCheckOnMove(class_1688 minecart, class_1313 moverType, class_243 vec32, @Local(ordinal = 0) class_2768 railShape) {
		if (vec32.method_37267() < 0.6) {
			minecart.method_5784(moverType, vec32);
			return;
		}
		class_243 destination = minecart.method_19538().method_1019(vec32);
		int i = class_3532.method_15357(destination.field_1352);
		int j = class_3532.method_15357(destination.field_1351);
		int k = class_3532.method_15357(destination.field_1350);
		class_2680 destinationBlockState = minecart.method_37908().method_8320(new class_2338(i, j, k));
		if (destinationBlockState.method_26164(class_3481.field_15463)) {
			class_2768 destinationShape = destinationBlockState.method_11654(((class_2241) destinationBlockState.method_26204()).method_9474());
			if (destinationShape == class_2768.field_12667 && vec32.field_1352 > 0.6 ||
					destinationShape == class_2768.field_12666 && vec32.field_1352 < -0.6 ||
					destinationShape == class_2768.field_12668 && vec32.field_1350 > 0.6 ||
					destinationShape == class_2768.field_12670 && vec32.field_1350 > -0.6
			) {
				minecart.method_5814(minecart.method_23317(), minecart.method_23318() + 1, minecart.method_23321());
			}
		}
		minecart.method_5784(moverType, vec32);
	}
}