package net.robofox.copperrails.block;

import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.registry.OxidizableBlocksRegistry;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_5955;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.robofox.copperrails.CopperRails;
import net.robofox.copperrails.block.custom.CrossingRailBlock;
import net.robofox.copperrails.block.custom.GenericCopperRailBlock;
import net.robofox.copperrails.block.custom.OxidizableCopperRailBlock;

public class ModBlocks {

    public static final class_2248 COPPER_RAIL = register(new OxidizableCopperRailBlock(class_5955.class_5811.field_28704, class_4970.class_2251.method_9630(class_2246.field_10425).method_31710(class_3620.field_15987)), "copper_rail");
    public static final class_2248 EXPOSED_COPPER_RAIL = register(new OxidizableCopperRailBlock(class_5955.class_5811.field_28705, class_4970.class_2251.method_9630(class_2246.field_10425).method_31710(class_3620.field_15988)), "exposed_copper_rail");
    public static final class_2248 WEATHERED_COPPER_RAIL = register(new OxidizableCopperRailBlock(class_5955.class_5811.field_28706, class_4970.class_2251.method_9630(class_2246.field_10425).method_31710(class_3620.field_25706)), "weathered_copper_rail");
    public static final class_2248 OXIDIZED_COPPER_RAIL = register(new OxidizableCopperRailBlock(class_5955.class_5811.field_28707, class_4970.class_2251.method_9630(class_2246.field_10425).method_31710(class_3620.field_25705)), "oxidized_copper_rail");
    public static final class_2248 WAXED_COPPER_RAIL = register(new GenericCopperRailBlock(class_4970.class_2251.method_9630(ModBlocks.COPPER_RAIL)), "waxed_copper_rail");
    public static final class_2248 WAXED_EXPOSED_COPPER_RAIL = register(new GenericCopperRailBlock(class_4970.class_2251.method_9630(ModBlocks.EXPOSED_COPPER_RAIL)), "waxed_exposed_copper_rail");
    public static final class_2248 WAXED_WEATHERED_COPPER_RAIL = register(new GenericCopperRailBlock(class_4970.class_2251.method_9630(ModBlocks.WEATHERED_COPPER_RAIL)), "waxed_weathered_copper_rail");
    public static final class_2248 WAXED_OXIDIZED_COPPER_RAIL = register(new GenericCopperRailBlock(class_4970.class_2251.method_9630(ModBlocks.OXIDIZED_COPPER_RAIL)), "waxed_oxidized_copper_rail");
    public static final class_2248 RAIL_CROSSING = register(new CrossingRailBlock(class_4970.class_2251.method_9630(class_2246.field_10425)), "rail_crossing");

    public static void initialize() {
        putInRedstoneTab(ModBlocks.COPPER_RAIL);
        putInRedstoneTab(ModBlocks.EXPOSED_COPPER_RAIL);
        putInRedstoneTab(ModBlocks.WEATHERED_COPPER_RAIL);
        putInRedstoneTab(ModBlocks.OXIDIZED_COPPER_RAIL);
        putInRedstoneTab(ModBlocks.WAXED_COPPER_RAIL);
        putInRedstoneTab(ModBlocks.WAXED_EXPOSED_COPPER_RAIL);
        putInRedstoneTab(ModBlocks.WAXED_WEATHERED_COPPER_RAIL);
        putInRedstoneTab(ModBlocks.WAXED_OXIDIZED_COPPER_RAIL);
        putInRedstoneTab(ModBlocks.RAIL_CROSSING);

        // Register copper rails for oxidation
        OxidizableBlocksRegistry.registerOxidizableBlockPair(ModBlocks.COPPER_RAIL, ModBlocks.EXPOSED_COPPER_RAIL);
        OxidizableBlocksRegistry.registerOxidizableBlockPair(ModBlocks.EXPOSED_COPPER_RAIL, ModBlocks.WEATHERED_COPPER_RAIL);
        OxidizableBlocksRegistry.registerOxidizableBlockPair(ModBlocks.WEATHERED_COPPER_RAIL, ModBlocks.OXIDIZED_COPPER_RAIL);
        OxidizableBlocksRegistry.registerWaxableBlockPair(ModBlocks.COPPER_RAIL, ModBlocks.WAXED_COPPER_RAIL);
        OxidizableBlocksRegistry.registerWaxableBlockPair(ModBlocks.EXPOSED_COPPER_RAIL, ModBlocks.WAXED_EXPOSED_COPPER_RAIL);
        OxidizableBlocksRegistry.registerWaxableBlockPair(ModBlocks.WEATHERED_COPPER_RAIL, ModBlocks.WAXED_WEATHERED_COPPER_RAIL);
        OxidizableBlocksRegistry.registerWaxableBlockPair(ModBlocks.OXIDIZED_COPPER_RAIL, ModBlocks.WAXED_OXIDIZED_COPPER_RAIL);
    }

    public static void putInRedstoneTab(class_2248 block) {
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40198)
                .register((itemGroup) -> itemGroup.method_45421(block.method_8389()));
    }

    private static class_2248 register(class_2248 block, String id) {
        class_2960 blockID = class_2960.method_60655(CopperRails.MOD_ID, id);
        class_1747 blockItem = new class_1747(block, new class_1792.class_1793());
        class_2378.method_10230(class_7923.field_41178, blockID, blockItem);
        return class_2378.method_10230(class_7923.field_41175, blockID, block);
    }
}
