package net.robofox.copperrails.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2452;
import net.minecraft.class_2680;
import net.robofox.copperrails.block.ModBlocks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_2452.class)
public class RailStateMixin {

    @Unique
    private static boolean canMakeSlopes(class_1937 world, class_2338 blockPos, class_2338 blockPosCheckSlopes, Operation<Boolean> original) {
        class_2680 railBlockStateCheckSlopes = world.method_8320(blockPosCheckSlopes);
        return !railBlockStateCheckSlopes.method_27852(ModBlocks.RAIL_CROSSING) && original.call(world, blockPos);
    }

    /**
     * Mixin to check if original rail is allowed to be sloped (in this case crossing)
     * One function for each direction
     * For connectTo mixin
     */
    @WrapOperation(
            method = "connectTo",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/level/block/BaseRailBlock;isRail(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Z",
                    ordinal = 0
            ))
    private boolean isRailMixinComputeRailShapeNorth(class_1937 level, class_2338 blockPos, Operation<Boolean> original) {
        return canMakeSlopes(level, blockPos, blockPos.method_10074().method_10072(), original);
    }
    @WrapOperation(
            method = "connectTo",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/level/block/BaseRailBlock;isRail(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Z",
                    ordinal = 1
            )
    )
    private boolean isRailMixinComputeRailShapeSouth(class_1937 world, class_2338 blockPos, Operation<Boolean> original) {
        return canMakeSlopes(world, blockPos, blockPos.method_10074().method_10095(), original);
    }
    @WrapOperation(
            method = "connectTo",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/level/block/BaseRailBlock;isRail(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Z",
                    ordinal = 2
            )
    )
    private boolean isRailMixinComputeRailShapeEast(class_1937 world, class_2338 blockPos, Operation<Boolean> original) {
        return canMakeSlopes(world, blockPos, blockPos.method_10074().method_10067(), original);
    }

    @WrapOperation(
            method = "connectTo",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/level/block/BaseRailBlock;isRail(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Z",
                    ordinal = 3
            )
    )
    private boolean isRailMixinComputeRailShapeWest(class_1937 world, class_2338 blockPos, Operation<Boolean> original) {
        return canMakeSlopes(world, blockPos, blockPos.method_10074().method_10078(), original);
    }

    /**
     * Mixin to check if original rail is allowed to be sloped (in this case crossing)
     * One function for each direction
     * For place mixin
     */
    @WrapOperation(
            method = "place",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/level/block/BaseRailBlock;isRail(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Z",
                    ordinal = 0
            )
    )
    private boolean isRailMixinUpdateBlockStateNorth(class_1937 world, class_2338 blockPos, Operation<Boolean> original) {
        return canMakeSlopes(world, blockPos, blockPos.method_10074().method_10072(), original);
    }

    @WrapOperation(
            method = "place",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/level/block/BaseRailBlock;isRail(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Z",
                    ordinal = 1
            )
    )
    private boolean isRailMixinUpdateBlockStateSouth(class_1937 world, class_2338 blockPos, Operation<Boolean> original) {
        return canMakeSlopes(world, blockPos, blockPos.method_10074().method_10095(), original);
    }

    @WrapOperation(
            method = "place",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/level/block/BaseRailBlock;isRail(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Z",
                    ordinal = 2
            )
    )
    private boolean isRailMixinUpdateBlockStateEast(class_1937 world, class_2338 blockPos, Operation<Boolean> original) {
        return canMakeSlopes(world, blockPos, blockPos.method_10074().method_10067(), original);
    }

    @WrapOperation(
            method = "place",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/level/block/BaseRailBlock;isRail(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Z",
                    ordinal = 3
            )
    )
    private boolean isRailMixinUpdateBlockStateWest(class_1937 world, class_2338 blockPos, Operation<Boolean> original) {
        return canMakeSlopes(world, blockPos, blockPos.method_10074().method_10078(), original);
    }

}