/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.block.soil.SoilProperties;
import com.dtteam.dynamictrees.client.BlockColorMultipliers;
import com.dtteam.dynamictrees.config.DTConfigs;
import com.dtteam.dynamictrees.data.GatherDataHelper;
import com.dtteam.dynamictrees.data.generator.DTExtraLangGenerator;
import com.dtteam.dynamictrees.data.generator.DataGenerators;
import com.dtteam.dynamictrees.event.handler.OptionalHandlers;
import com.dtteam.dynamictrees.registry.NeoForgeRegistryHandler;
import com.dtteam.dynamictrees.registry.NeoForgeRegistryLoader;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.treepack.Resources;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@Mod(value="dynamictrees")
public class DynamicTreesNeoForge {
    public DynamicTreesNeoForge(IEventBus eventBus, ModContainer container) {
        eventBus.addListener(this::clientSetup);
        eventBus.addListener(this::onCommonSetup);
        eventBus.addListener(this::gatherData);
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)DTConfigs.SERVER_CONFIG);
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)DTConfigs.COMMON_CONFIG);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)DTConfigs.CLIENT_CONFIG);
        NeoForgeRegistryHandler.setup("dynamictrees", eventBus);
        DynamicTrees.init();
        NeoForgeRegistryLoader.setup(eventBus);
        OptionalHandlers.registerHandlers();
        DataGenerators.register();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        LeavesProperties.postInitClient();
        BlockColorMultipliers.cleanUp();
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        DynamicTrees.commonSetup();
    }

    private void gatherData(GatherDataEvent event) {
        Resources.MANAGER.gatherData();
        GatherDataHelper.gatherAllData("dynamictrees", event, new DTExtraLangGenerator(), SoilProperties.REGISTRY, Family.REGISTRY, Species.REGISTRY, LeavesProperties.REGISTRY);
    }
}

