/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.api.cell;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.api.cell.Cell;
import com.dtteam.dynamictrees.api.cell.CellNull;
import com.dtteam.dynamictrees.api.cell.CellSolver;
import com.dtteam.dynamictrees.api.registry.RegistryEntry;
import com.dtteam.dynamictrees.api.registry.SimpleRegistry;
import com.dtteam.dynamictrees.api.voxmap.SimpleVoxmap;
import com.dtteam.dynamictrees.utility.ResourceLocationUtils;
import net.minecraft.resources.ResourceLocation;

public abstract class CellKit
extends RegistryEntry<CellKit> {
    public static final CellSolver NULL_CELL_SOLVER = cells -> 0;
    public static final CellKit NULL_CELL_KIT = new CellKit(DynamicTrees.NULL){

        @Override
        public Cell getCellForLeaves(int hydro) {
            return CellNull.NULL_CELL;
        }

        @Override
        public Cell getCellForBranch(int radius, int meta) {
            return CellNull.NULL_CELL;
        }

        @Override
        public CellSolver getCellSolver() {
            return NULL_CELL_SOLVER;
        }

        @Override
        public SimpleVoxmap getLeafCluster() {
            return null;
        }

        @Override
        public int getDefaultHydration() {
            return 0;
        }
    };
    public static final SimpleRegistry<CellKit> REGISTRY = new SimpleRegistry<CellKit>(CellKit.class, NULL_CELL_KIT);

    public CellKit(ResourceLocation registryName) {
        this.setRegistryName(registryName);
    }

    public abstract Cell getCellForLeaves(int var1);

    public abstract Cell getCellForBranch(int var1, int var2);

    public abstract CellSolver getCellSolver();

    public abstract SimpleVoxmap getLeafCluster();

    public abstract int getDefaultHydration();

    public static CellKit findCellKit(String name) {
        return CellKit.findCellKit(ResourceLocationUtils.parseDTLocation(name));
    }

    public static CellKit findCellKit(ResourceLocation name) {
        return (CellKit)REGISTRY.get(name);
    }
}

