/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.block.branch;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.api.network.BranchDestructionData;
import com.dtteam.dynamictrees.api.network.Connections;
import com.dtteam.dynamictrees.api.network.MapSignal;
import com.dtteam.dynamictrees.api.treedata.BranchShapeState;
import com.dtteam.dynamictrees.api.treedata.TreePart;
import com.dtteam.dynamictrees.api.voxmap.BlockPosBounds;
import com.dtteam.dynamictrees.api.voxmap.SimpleVoxmap;
import com.dtteam.dynamictrees.block.BlockWithDynamicHardness;
import com.dtteam.dynamictrees.block.FutureBreakable;
import com.dtteam.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.block.soil.SoilBlock;
import com.dtteam.dynamictrees.data.DTLootTableBuilder;
import com.dtteam.dynamictrees.entity.FallingTreeEntity;
import com.dtteam.dynamictrees.loot.LootTableSupplier;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.systems.FutureBreak;
import com.dtteam.dynamictrees.systems.nodemapper.DestroyerNode;
import com.dtteam.dynamictrees.systems.nodemapper.NetVolumeNode;
import com.dtteam.dynamictrees.systems.nodemapper.SpeciesNode;
import com.dtteam.dynamictrees.systems.nodemapper.StateNode;
import com.dtteam.dynamictrees.tree.ChunkTreeHelper;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.utility.EntityUtils;
import com.dtteam.dynamictrees.utility.ItemUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BranchBlock
extends BlockWithDynamicHardness
implements TreePart,
FutureBreakable,
BonemealableBlock {
    public static final int MAX_RADIUS = 8;
    public static final String NAME_SUFFIX = "_branch";
    protected static final VoxelShape[] shapeCache = new VoxelShape[BranchShapeState.TOTAL_STATES];
    public static DynamicTrees.DestroyMode destroyMode = DynamicTrees.DestroyMode.SLOPPY;
    private Family family = Family.NULL_FAMILY;
    private ItemStack[] primitiveLogDrops = new ItemStack[0];
    private boolean canBeStripped;
    private final LootTableSupplier lootTableSupplier;

    public BranchBlock(ResourceLocation name) {
        this(name, BlockBehaviour.Properties.of().pushReaction(PushReaction.BLOCK));
    }

    public BranchBlock(ResourceLocation name, BlockBehaviour.Properties properties) {
        super(properties);
        this.lootTableSupplier = new LootTableSupplier("trees/branches/", name);
    }

    public BranchBlock setCanBeStripped(boolean truth) {
        this.canBeStripped = truth;
        return this;
    }

    public void setFamily(Family tree) {
        this.family = tree;
    }

    public Family getFamily() {
        return this.family;
    }

    @Override
    public Family getFamily(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getFamily();
    }

    public boolean isSameTree(TreePart treepart) {
        return this.isSameTree(TreeHelper.getBranch(treepart));
    }

    public boolean isSameTree(BlockState state) {
        return TreeHelper.getBranchOpt(state).map(branch -> this.getFamily() == branch.getFamily()).orElse(false);
    }

    public boolean isSameTree(@Nullable BranchBlock branch) {
        return branch != null && this.getFamily() == branch.getFamily();
    }

    public Optional<Block> getPrimitiveLog() {
        return this.isStrippedBranch() ? this.family.getPrimitiveStrippedLog() : this.family.getPrimitiveLog();
    }

    public boolean isStrippedBranch() {
        return this.getFamily().getStrippedBranch().map(other -> other == this).orElse(false);
    }

    @Override
    public abstract int branchSupport(BlockState var1, BlockGetter var2, BranchBlock var3, BlockPos var4, Direction var5, int var6);

    public abstract boolean checkForRot(LevelAccessor var1, BlockPos var2, Species var3, int var4, int var5, RandomSource var6, float var7, boolean var8);

    public static int setSupport(int branches, int leaves) {
        return (branches & 0xF) << 4 | leaves & 0xF;
    }

    public static int getBranchSupport(int support) {
        return support >> 4 & 0xF;
    }

    public static int getLeavesSupport(int support) {
        return support & 0xF;
    }

    public static boolean isNextToBranch(Level level, BlockPos pos, Direction originDir) {
        for (Direction dir : Direction.values()) {
            if (dir.equals((Object)originDir) || !TreeHelper.isBranch(level.getBlockState(pos.relative(dir)))) continue;
            return true;
        }
        return false;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return TreeHelper.getTreePart(state).getFamily(state, (BlockGetter)level, pos).onTreeActivated(new Family.TreeActivationContext(level, TreeHelper.findRootNode(level, pos), pos, state, player, hand, stack, hitResult)) ? ItemInteractionResult.SUCCESS : ItemInteractionResult.FAIL;
    }

    public boolean canBeStripped(BlockState state, Level level, BlockPos pos, Player player, ItemStack heldItem) {
        int stripRadius = this.getFamily().getMinRadiusForStripping();
        return stripRadius != 0 && stripRadius <= this.getRadius(state) && this.canBeStripped && Services.INTERACTION.canToolAxeStrip(heldItem);
    }

    public void stripBranch(BlockState state, Level level, BlockPos pos, Player player, ItemStack heldItem) {
        int radius = this.getRadius(state);
        this.damageAxe((LivingEntity)player, heldItem, radius / 2, new NetVolumeNode.Volume(radius * radius * 64 / 2), false);
        this.stripBranch(state, (LevelAccessor)level, pos, radius);
    }

    public void stripBranch(BlockState state, LevelAccessor level, BlockPos pos, int radius) {
        this.getFamily().getStrippedBranch().ifPresent(strippedBranch -> strippedBranch.setRadius(level, pos, Math.max(1, radius - (this.getFamily().reduceRadiusWhenStripping() ? 1 : 0)), null, 3));
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return this.getFamily().getBranchItem().map(ItemStack::new).orElse(ItemStack.EMPTY);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public BlockState getStateForDecay(BlockState state, LevelAccessor level, BlockPos pos) {
        return Blocks.AIR.defaultBlockState();
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        if (!(levelReader instanceof Level)) {
            return false;
        }
        Level level = (Level)levelReader;
        BlockPos rootPos = TreeHelper.findRootNode(level, blockPos);
        if (rootPos == BlockPos.ZERO) {
            return false;
        }
        BlockState rootState = levelReader.getBlockState(rootPos);
        SoilBlock root = TreeHelper.getRooty(rootState);
        if (root == null) {
            return false;
        }
        return root.isValidBonemealTarget(levelReader, rootPos, rootState);
    }

    public boolean isBonemealSuccess(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void performBonemeal(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        BlockPos rootPos = TreeHelper.findRootNode((Level)pLevel, pPos);
        if (rootPos == BlockPos.ZERO) {
            return;
        }
        BlockState rootState = pLevel.getBlockState(rootPos);
        SoilBlock root = TreeHelper.getRooty(rootState);
        if (root == null) {
            return;
        }
        root.performBonemeal(pLevel, pRandom, rootPos, rootState);
    }

    public Connections getConnectionData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Connections connections = new Connections();
        if (state.getBlock() != this) {
            return connections;
        }
        int coreRadius = this.getRadius(state);
        for (Direction dir : Direction.values()) {
            BlockPos deltaPos = pos.relative(dir);
            BlockState neighborBlockState = level.getBlockState(deltaPos);
            int sideRadius = TreeHelper.getTreePart(neighborBlockState).getRadiusForConnection(neighborBlockState, (BlockGetter)level, deltaPos, this, dir, coreRadius);
            connections.setRadius(dir, Mth.clamp((int)sideRadius, (int)0, (int)coreRadius));
        }
        return connections;
    }

    public boolean connectToLeaves(BlockGetter blockAccess, BlockPos leavesPos, Direction branchConnectionDir, int branchRadius) {
        return true;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape newShape;
        byte[] radii = new byte[7];
        int radius = this.getRadius(state);
        if (radius == 8) {
            return Shapes.block();
        }
        radii[6] = (byte)radius;
        for (Direction dir : Direction.values()) {
            radii[dir.ordinal()] = (byte)Math.min(this.getSideConnectionRadius(level, pos, radius, dir), radius);
        }
        int shapeStateIndex = BranchShapeState.fromArray(radii).toIndex();
        VoxelShape cachedShape = shapeCache[shapeStateIndex];
        if (cachedShape != null) {
            return cachedShape;
        }
        BranchBlock.shapeCache[shapeStateIndex] = newShape = BranchBlock.generateNewShape(radii);
        return newShape;
    }

    private static VoxelShape generateNewShape(byte[] radii) {
        double radius = (double)radii[6] / 16.0;
        VoxelShape shape = Shapes.create((AABB)BranchBlock.makeCube(radius));
        for (Direction dir : Direction.values()) {
            double sideRadius = (float)radii[dir.ordinal()] / 16.0f;
            if (!(sideRadius > 0.0)) continue;
            double gap = 0.5 - sideRadius;
            AABB aabb = BranchBlock.makeCube(sideRadius);
            aabb = aabb.expandTowards((double)dir.getStepX() * gap, (double)dir.getStepY() * gap, (double)dir.getStepZ() * gap);
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.create((AABB)aabb));
        }
        return shape;
    }

    protected static AABB makeCube(double radius) {
        return new AABB(0.5 - radius, 0.5 - radius, 0.5 - radius, 0.5 + radius, 0.5 + radius, 0.5 + radius);
    }

    protected int getSideConnectionRadius(BlockGetter level, BlockPos pos, int radius, Direction side) {
        BlockPos deltaPos = pos.relative(side);
        BlockState blockState = ChunkTreeHelper.getStateSafe(level, deltaPos);
        return blockState == null ? 0 : TreeHelper.getTreePart(blockState).getRadiusForConnection(blockState, level, deltaPos, this, side, radius);
    }

    @Override
    public int getRadius(BlockState state) {
        return 1;
    }

    public abstract int setRadius(LevelAccessor var1, BlockPos var2, int var3, @Nullable Direction var4, int var5);

    public int setRadius(LevelAccessor level, BlockPos pos, int radius, @Nullable Direction originDir) {
        return this.setRadius(level, pos, radius, originDir, 2);
    }

    public abstract BlockState getStateForRadius(int var1);

    public int getMaxRadius() {
        return 8;
    }

    @Override
    public boolean shouldAnalyse(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public BranchDestructionData destroyBranchFromNode(Level level, BlockPos cutPos, Direction toolDir, boolean wholeTree, @Nullable LivingEntity entity) {
        BlockState blockState = level.getBlockState(cutPos);
        SpeciesNode speciesNode = new SpeciesNode();
        MapSignal signal = this.analyse(blockState, (LevelAccessor)level, cutPos, null, new MapSignal(speciesNode));
        Species species = speciesNode.getSpecies();
        StateNode stateMapper = new StateNode(cutPos);
        this.analyse(blockState, (LevelAccessor)level, cutPos, wholeTree ? null : signal.localRootDir, new MapSignal(stateMapper));
        NetVolumeNode volumeSum = new NetVolumeNode();
        DestroyerNode destroyer = new DestroyerNode(species).setPlayer(entity instanceof Player ? (Player)entity : null);
        destroyMode = DynamicTrees.DestroyMode.HARVEST;
        this.analyse(blockState, (LevelAccessor)level, cutPos, wholeTree ? null : signal.localRootDir, new MapSignal(volumeSum, destroyer));
        destroyMode = DynamicTrees.DestroyMode.SLOPPY;
        List<Object> endPoints = destroyer.getEnds();
        HashMap<BlockPos, BlockState> destroyedLeaves = new HashMap<BlockPos, BlockState>();
        ArrayList<ItemStackPos> leavesDropsList = new ArrayList<ItemStackPos>();
        if (species != Species.NULL_SPECIES) {
            this.destroyLeaves(level, cutPos, species, entity == null ? ItemStack.EMPTY : entity.getMainHandItem(), endPoints, destroyedLeaves, leavesDropsList);
        }
        endPoints = endPoints.stream().map(p -> p.subtract((Vec3i)cutPos)).collect(Collectors.toList());
        int trunkHeight = 1;
        BlockPos iter = new BlockPos(0, 1, 0);
        while (stateMapper.getBranchConnectionMap().containsKey(iter)) {
            ++trunkHeight;
            iter = iter.above();
        }
        Direction cutDir = signal.localRootDir;
        if (cutDir == null) {
            cutDir = Direction.DOWN;
        }
        Pair<ResourceLocation, Integer> cachedState = BranchBlock.getCachedSoilState(level, cutPos.offset(cutDir.getNormal()), false);
        return new BranchDestructionData(species, stateMapper.getBranchConnectionMap(), destroyedLeaves, leavesDropsList, endPoints, volumeSum.getVolume(), cutPos, cutPos, cutDir, toolDir, trunkHeight, cachedState);
    }

    @Nullable
    protected static Pair<ResourceLocation, Integer> getCachedSoilState(Level level, BlockPos rootPos, boolean hasRoots) {
        BlockState soilState = level.getBlockState(rootPos);
        SoilBlock soilBlock = TreeHelper.getRooty(soilState);
        if (soilBlock != null && soilBlock.fallWithTree(soilState, level, rootPos, hasRoots)) {
            ResourceLocation blockResLoc = BuiltInRegistries.BLOCK.getKey((Object)soilBlock);
            int stateId = soilBlock.getStateIndex(soilState);
            return Pair.of((Object)blockResLoc, (Object)stateId);
        }
        return null;
    }

    public void rot(LevelAccessor level, BlockPos pos) {
        this.breakDeliberate(level, pos, DynamicTrees.DestroyMode.ROT);
    }

    public void destroyLeaves(Level level, BlockPos cutPos, Species species, ItemStack tool, List<BlockPos> endPoints, Map<BlockPos, BlockState> destroyedLeaves, List<ItemStackPos> drops) {
        if (level.isClientSide || endPoints.isEmpty()) {
            return;
        }
        BlockPosBounds bounds = this.getFamily().expandLeavesBlockBounds(new BlockPosBounds(endPoints));
        SimpleVoxmap leafMap = new SimpleVoxmap(bounds);
        for (BlockPos endPos : endPoints) {
            for (BlockPos leafPos : this.getFamily().expandLeavesBlockBounds(new BlockPosBounds(endPos))) {
                leafMap.setVoxel(leafPos, (byte)1);
            }
            leafMap.setVoxel(endPos, (byte)0);
        }
        Family family = species.getFamily();
        BranchBlock familyBranch = family.getBranch().get();
        int primaryThickness = family.getPrimaryThickness();
        for (BlockPos findPos : this.getFamily().expandLeavesBlockBounds(bounds)) {
            BlockState findState = level.getBlockState(findPos);
            if (familyBranch.getRadius(findState) != primaryThickness) continue;
            Iterable<BlockPos.MutableBlockPos> leaves = species.getLeavesProperties().getCellKit().getLeafCluster().getAllNonZero();
            for (BlockPos.MutableBlockPos leafPos : leaves) {
                leafMap.setVoxel(findPos.getX() + leafPos.getX(), findPos.getY() + leafPos.getY(), findPos.getZ() + leafPos.getZ(), (byte)0);
            }
        }
        ArrayList<ItemStack> dropList = new ArrayList<ItemStack>();
        for (SimpleVoxmap.VoxmapCell cell : leafMap.getAllNonZeroCells()) {
            BlockPos.MutableBlockPos pos = cell.getPos();
            BlockState state = level.getBlockState((BlockPos)pos);
            if (!family.isCompatibleGenericLeaves(species, state, (LevelAccessor)level, (BlockPos)pos)) continue;
            dropList.clear();
            LeavesProperties leaves = Optional.ofNullable(TreeHelper.getLeaves(state)).map(DynamicLeavesBlock::getLeavesProperties).orElse(LeavesProperties.NULL);
            dropList.addAll(leaves.getDrops(level, (BlockPos)pos, tool, species));
            BlockPos imPos = pos.immutable();
            BlockPos relPos = imPos.subtract((Vec3i)cutPos);
            level.setBlock(imPos, Blocks.AIR.defaultBlockState(), 3);
            destroyedLeaves.put(relPos, state);
            dropList.forEach(i -> drops.add(new ItemStackPos((ItemStack)i, relPos)));
        }
    }

    public boolean canFall() {
        return false;
    }

    public boolean shouldGenerateBranchDrops() {
        return this.getPrimitiveLog().isPresent();
    }

    public ResourceLocation getLootTableName() {
        return this.lootTableSupplier.getName();
    }

    public LootTable getLootTable(ReloadableServerRegistries.Holder lootTables, Species species) {
        return this.lootTableSupplier.get(lootTables, species);
    }

    public LootTable.Builder createBranchDrops(HolderLookup.Provider registries) {
        return DTLootTableBuilder.createBranchDrops(this.getPrimitiveLog().get(), this.family.getStick(1).getItem(), registries);
    }

    public float getPrimitiveLogs(float volumeIn, List<ItemStack> drops) {
        int numLogs = (int)volumeIn;
        for (ItemStack stack : this.primitiveLogDrops) {
            for (int num = numLogs * stack.getCount(); num > 0; num -= stack.getMaxStackSize()) {
                ItemStack drop = stack.copy();
                drop.setCount(Math.min(num, stack.getMaxStackSize()));
                drops.add(drop);
            }
        }
        return volumeIn - (float)numLogs;
    }

    public BranchBlock setPrimitiveLogDrops(ItemStack ... drops) {
        this.primitiveLogDrops = drops;
        return this;
    }

    @Override
    public void futureBreak(BlockState state, Level level, BlockPos cutPos, LivingEntity entity) {
        Direction toolDir = EntityUtils.getHitDirection(entity);
        level.levelEvent(null, 2001, cutPos, BranchBlock.getId((BlockState)state));
        BranchDestructionData destroyData = this.destroyBranchFromNode(level, cutPos, toolDir, false, entity);
        ItemStack heldItem = entity.getMainHandItem();
        int fortune = ItemUtils.getEnchantmentLevel((ResourceKey<Enchantment>)Enchantments.FORTUNE, heldItem, level.registryAccess());
        float fortuneFactor = 1.0f + 0.25f * (float)fortune;
        NetVolumeNode.Volume woodVolume = destroyData.woodVolume;
        woodVolume.multiplyVolume(fortuneFactor);
        List<ItemStack> woodItems = destroyData.species.getBranchesDrops(level, woodVolume, heldItem);
        float chance = 1.0f;
        List<ItemStack> woodDropList = woodItems.stream().filter(i -> level.random.nextFloat() <= 1.0f).toList();
        FallingTreeEntity.dropTree(level, destroyData, woodDropList, FallingTreeEntity.DestroyType.HARVEST);
        this.damageAxe(entity, heldItem, this.getRadius(state), woodVolume, true);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        FutureBreak.add(new FutureBreak(state, level, pos, (LivingEntity)player, 0));
        return false;
    }

    protected void sloppyBreak(Level level, BlockPos cutPos, FallingTreeEntity.DestroyType destroyType) {
        BranchDestructionData destroyData = this.destroyBranchFromNode(level, cutPos, Direction.DOWN, false, null);
        List<ItemStack> woodDropList = destroyData.species.getBranchesDrops(level, destroyData.woodVolume);
        if (!Services.CONFIG.getBoolConfig("sloppyBreakDrops").booleanValue()) {
            destroyData.leavesDrops.clear();
            woodDropList.clear();
        }
        FallingTreeEntity.dropTree(level, destroyData, woodDropList, destroyType);
    }

    public void damageAxe(LivingEntity entity, @Nullable ItemStack heldItem, int radius, NetVolumeNode.Volume woodVolume, boolean forBlockBreak) {
        ItemUtils.damageAxe(entity, heldItem, radius, woodVolume, forBlockBreak);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockPos offPos;
        if (level.isClientSide || destroyMode != DynamicTrees.DestroyMode.SLOPPY) {
            super.onRemove(state, level, pos, newState, movedByPiston);
            return;
        }
        BlockState toBlockState = level.getBlockState(pos);
        Block toBlock = toBlockState.getBlock();
        if (toBlock instanceof BranchBlock) {
            return;
        }
        boolean foundFire = toBlockState.is(BlockTags.FIRE);
        if (!foundFire) {
            for (Direction offset : Direction.values()) {
                offPos = pos.offset(offset.getNormal());
                if (!level.getBlockState(offPos).is(BlockTags.FIRE)) continue;
                foundFire = true;
                break;
            }
        }
        if (foundFire) {
            level.setBlock(pos, state, 0);
            this.sloppyBreak(level, pos, FallingTreeEntity.DestroyType.FIRE);
            this.setBlockStateIgnored(level, pos, Blocks.AIR.defaultBlockState(), 2);
            return;
        }
        if (toBlock == Blocks.AIR) {
            level.setBlock(pos, state, 0);
            this.sloppyBreak(level, pos, FallingTreeEntity.DestroyType.VOID);
            this.setBlockStateIgnored(level, pos, Blocks.AIR.defaultBlockState(), 2);
            return;
        }
        if (level.getBlockEntity(pos) == null) {
            level.setBlock(pos, state, 0);
            this.sloppyBreak(level, pos, FallingTreeEntity.DestroyType.VOID);
            this.setBlockStateIgnored(level, pos, toBlockState, 2);
            return;
        }
        for (Direction dir : Direction.values()) {
            offPos = pos.relative(dir);
            BlockState offState = level.getBlockState(offPos);
            if (!(offState.getBlock() instanceof BranchBlock)) continue;
            this.sloppyBreak(level, offPos, FallingTreeEntity.DestroyType.VOID);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public void setBlockStateIgnored(Level level, BlockPos pos, BlockState state, int flags) {
        destroyMode = DynamicTrees.DestroyMode.IGNORE;
        level.setBlock(pos, state, flags);
        destroyMode = DynamicTrees.DestroyMode.SLOPPY;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        return state;
    }

    public void breakDeliberate(LevelAccessor level, BlockPos pos, DynamicTrees.DestroyMode mode) {
        destroyMode = mode;
        FluidState state = level.getFluidState(pos);
        if (state.isEmpty()) {
            level.removeBlock(pos, false);
        } else {
            level.setBlock(pos, state.createLegacyBlock(), 3);
        }
        destroyMode = DynamicTrees.DestroyMode.SLOPPY;
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        NetVolumeNode.Volume woodVolume;
        List<ItemStack> woodDropList;
        SpeciesNode speciesNode = new SpeciesNode();
        MapSignal signal = this.analyse(state, (LevelAccessor)level, pos, null, new MapSignal(speciesNode));
        if (signal.foundRoot) {
            level.scheduleTick(signal.root, level.getBlockState(signal.root).getBlock(), 2);
        }
        Species species = speciesNode.getSpecies();
        BranchDestructionData destroyData = this.destroyBranchFromNode(level, pos, Direction.DOWN, false, null);
        FallingTreeEntity treeEntity = FallingTreeEntity.dropTree(level, destroyData, woodDropList = species.getBranchesDrops(level, woodVolume = destroyData.woodVolume, ItemStack.EMPTY, Float.valueOf(explosion.radius())), FallingTreeEntity.DestroyType.EXPLODE);
        if (treeEntity != null) {
            Vec3 expPos = explosion.center();
            double distance = Math.sqrt(treeEntity.distanceToSqr(expPos.x, expPos.y, expPos.z));
            if (distance / (double)explosion.radius() <= 1.0 && distance != 0.0) {
                treeEntity.push((treeEntity.getX() - expPos.x) / distance, (treeEntity.getY() - expPos.y) / distance, (treeEntity.getZ() - expPos.z) / distance);
            }
        }
        this.wasExploded(level, pos, explosion);
    }

    @Override
    public final TreePart.TreePartType getTreePartType() {
        return TreePart.TreePartType.BRANCH;
    }

    public static class ItemStackPos {
        public final ItemStack stack;
        public final BlockPos pos;

        public ItemStackPos(ItemStack stack, BlockPos pos) {
            this.stack = stack;
            this.pos = pos;
        }
    }
}

