/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.block.branch;

import com.dtteam.dynamictrees.api.cell.Cell;
import com.dtteam.dynamictrees.api.cell.CellNull;
import com.dtteam.dynamictrees.block.branch.BasicBranchBlock;
import com.dtteam.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.systems.GrowSignal;
import com.dtteam.dynamictrees.tree.species.Species;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class PalmBranchBlock
extends BasicBranchBlock {
    public PalmBranchBlock(ResourceLocation name, BlockBehaviour.Properties properties) {
        super(name, properties);
    }

    @Override
    public Cell getHydrationCell(BlockGetter level, BlockPos pos, BlockState state, Direction dir, LeavesProperties leavesProperties) {
        if (this.getRadius(state) != this.getFamily().getPrimaryThickness()) {
            return CellNull.NULL_CELL;
        }
        return super.getHydrationCell(level, pos, state, dir, leavesProperties);
    }

    @Override
    public GrowSignal growIntoAir(Level world, BlockPos pos, GrowSignal signal, int fromRadius) {
        Species species = signal.getSpecies();
        DynamicLeavesBlock leaves = species.getLeavesBlock().orElse(null);
        if (leaves != null) {
            if (fromRadius == this.getFamily().getPrimaryThickness()) {
                if (PalmBranchBlock.isNextToBranch(world, pos, signal.dir.getOpposite())) {
                    signal.success = false;
                    return signal;
                }
                boolean bl = signal.success = 0 != leaves.growLeavesIfLocationIsSuitable((LevelAccessor)world, species.getLeavesProperties(), pos.above(), 0);
                if (signal.success) {
                    return leaves.branchOut(world, pos, signal);
                }
            } else {
                return leaves.branchOut(world, pos, signal);
            }
        }
        return super.growIntoAir(world, pos, signal, fromRadius);
    }
}

