/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.block.fruit;

import com.dtteam.dynamictrees.api.worldgen.LevelContext;
import com.dtteam.dynamictrees.block.Growable;
import com.dtteam.dynamictrees.block.fruit.Fruit;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.systems.season.SeasonHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FruitBlock
extends Block
implements BonemealableBlock,
Growable {
    protected final Fruit fruit;

    public FruitBlock(BlockBehaviour.Properties properties, Fruit fruit) {
        super(properties);
        this.fruit = fruit;
        StateDefinition.Builder builder = new StateDefinition.Builder((Object)this);
        this.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder);
        this.stateDefinition = builder.create(Block::defaultBlockState, BlockState::new);
        this.registerDefaultState((BlockState)this.stateDefinition.any());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        if (this.fruit != null) {
            builder.add(new Property[]{this.fruit.getAgeProperty()});
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.fruit.getBlockShape(this.getAge(state));
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.doTick(state, (Level)level, pos, random);
    }

    public void doTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!this.isSupported((LevelReader)level, pos, state)) {
            this.drop(level, pos, state);
            return;
        }
        int age = this.getAge(state);
        Float season = SeasonHelper.getSeasonValue(LevelContext.create((LevelAccessor)level), pos);
        if (season != null) {
            if (this.fruit.isOutOfSeason(level, pos)) {
                this.outOfSeason(level, pos);
                return;
            }
            if (age == 0 && this.fruit.isInFlowerHoldPeriod((LevelAccessor)level, pos, season).booleanValue()) {
                return;
            }
        }
        if (age < this.fruit.getMaxAge()) {
            this.tryGrow(state, level, pos, random, age, season);
        } else {
            this.tickMature(level, pos, state);
        }
    }

    private void outOfSeason(Level level, BlockPos pos) {
        level.destroyBlock(pos, false);
    }

    private void tryGrow(BlockState state, Level level, BlockPos pos, RandomSource random, int age, @Nullable Float season) {
        boolean doGrow = random.nextFloat() < this.getGrowthChance(level, pos);
        boolean eventGrow = Services.EVENT.canCropGrow(level, pos, state, doGrow);
        if (season != null ? doGrow || eventGrow : eventGrow) {
            this.setAge(level, pos, state, age + 1);
            Services.EVENT.cropGrowPost(level, pos, state);
        }
    }

    private float getGrowthChance(Level level, BlockPos pos) {
        return this.fruit.getGrowthChance();
    }

    public void tickMature(Level level, BlockPos pos, BlockState state) {
        this.fruit.performMatureAction(new Growable.Info((LevelAccessor)level, pos, state));
    }

    @Override
    public void performMatureAction(LevelAccessor level, BlockPos pos, BlockState state) {
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!this.isSupported((LevelReader)level, pos, state)) {
            this.drop(level, pos, state);
        }
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return this.isSupported(level, pos, state);
    }

    @Override
    public boolean isSupported(LevelReader level, BlockPos pos, BlockState state) {
        return level.getBlockState(pos.above()).getBlock() instanceof LeavesBlock;
    }

    protected void drop(Level level, BlockPos pos, BlockState state) {
        level.destroyBlock(pos, true);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return this.fruit.getItemStack();
    }

    public boolean harvest(BlockState state, Level level, BlockPos pos) {
        if (this.getAge(state) >= this.fruit.getMaxAge()) {
            this.drop(level, pos, state);
            return true;
        }
        return false;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return this.harvest(state, level, pos) ? ItemInteractionResult.SUCCESS : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return this.harvest(state, level, pos) ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return this.fruit.canBoneMeal() && this.getAge(blockState) < this.fruit.getMaxAge();
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        int age = this.getAge(state);
        int newAge = Math.min(age + 1, this.fruit.getMaxAge());
        if (newAge != age) {
            this.setAge((Level)level, pos, state, newAge);
        }
    }

    public int getAge(BlockState state) {
        return (Integer)state.getValue((Property)this.fruit.getAgeProperty());
    }

    public float getAgeAsPercentage(BlockState state) {
        return (float)this.getAge(state) * 100.0f / (float)this.getMaxAge();
    }

    public int getMaxAge() {
        return this.fruit.getMaxAge();
    }

    private void setAge(Level level, BlockPos pos, BlockState state, int newAge) {
        level.setBlock(pos, (BlockState)state.setValue((Property)this.fruit.getAgeProperty(), (Comparable)Integer.valueOf(newAge)), 2);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

