/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.block.soil;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.api.network.BranchDestructionData;
import com.dtteam.dynamictrees.api.network.MapSignal;
import com.dtteam.dynamictrees.api.registry.TypedRegistry;
import com.dtteam.dynamictrees.block.BlockWithDynamicHardness;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.soil.SoilBlock;
import com.dtteam.dynamictrees.block.soil.SoilProperties;
import com.dtteam.dynamictrees.data.tags.DTBlockTags;
import com.dtteam.dynamictrees.entity.FallingTreeEntity;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.systems.nodemapper.NetVolumeNode;
import com.dtteam.dynamictrees.systems.nodemapper.RootIntegrityNode;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.family.UndergroundRootsFamily;
import com.dtteam.dynamictrees.utility.EntityUtils;
import com.dtteam.dynamictrees.utility.ItemUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AerialRootsSoilProperties
extends SoilProperties {
    public static final TypedRegistry.EntryType<SoilProperties> TYPE = TypedRegistry.newType(AerialRootsSoilProperties::new);
    protected UndergroundRootsFamily family;

    public AerialRootsSoilProperties(ResourceLocation registryName) {
        super(registryName);
        this.soilStateGenerator.reset((Supplier)blockStateGenerators.get(DynamicTrees.location("aerial_root_soil")));
    }

    public void setFamily(UndergroundRootsFamily family) {
        this.family = family;
    }

    public UndergroundRootsFamily getFamily() {
        return this.family;
    }

    @Override
    protected SoilBlock createBlock(BlockBehaviour.Properties blockProperties) {
        return new RootSoilBlock(this, blockProperties);
    }

    @Override
    public BlockState getSoilState(BlockState primitiveSoilState, int fertility, boolean requireTileEntity) {
        BlockState rootyState = super.getSoilState(primitiveSoilState, fertility, requireTileEntity);
        if (rootyState.getBlock() instanceof RootSoilBlock) {
            return (BlockState)rootyState.setValue((Property)RootSoilBlock.WATERLOGGED, (Comparable)Boolean.valueOf(primitiveSoilState.getFluidState().is((Fluid)Fluids.WATER)));
        }
        return rootyState;
    }

    @Override
    public List<TagKey<Block>> defaultSoilBlockTags() {
        LinkedList<TagKey<Block>> defaultTags = new LinkedList<TagKey<Block>>(super.defaultSoilBlockTags());
        defaultTags.add(DTBlockTags.AERIAL_ROOTS_ROOTY_SOIL);
        return defaultTags;
    }

    public static class RootSoilBlock
    extends SoilBlock
    implements SimpleWaterloggedBlock {
        private static final int MIN_RADIUS = 1;
        private static final int MAX_RADIUS = 8;
        public static final IntegerProperty RADIUS = IntegerProperty.create((String)"radius", (int)1, (int)8);
        public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

        public RootSoilBlock(SoilProperties properties, BlockBehaviour.Properties blockProperties) {
            super(properties, blockProperties);
            this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)RADIUS, (Comparable)Integer.valueOf(8))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
            soilBlockDecayer = (level, rootPos, rootyState, species) -> true;
        }

        @Override
        public BlockState GetStateFromIndex(int index) {
            if (index <= 8 && index >= 1) {
                return (BlockState)this.defaultBlockState().setValue((Property)RADIUS, (Comparable)Integer.valueOf(index));
            }
            return this.defaultBlockState();
        }

        @Override
        public int getStateIndex(BlockState state) {
            if (!state.hasProperty((Property)RADIUS)) {
                return 0;
            }
            return (Integer)state.getValue((Property)RADIUS);
        }

        @Override
        public AerialRootsSoilProperties getSoilProperties() {
            return (AerialRootsSoilProperties)super.getSoilProperties();
        }

        @Override
        protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
            super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{RADIUS, WATERLOGGED}));
        }

        public FluidState getFluidState(BlockState state) {
            return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
        }

        public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
            if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
                level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
            }
            return super.updateShape(stateIn, facing, facingState, level, currentPos, facingPos);
        }

        @Override
        public float getHardness(BlockState state, BlockGetter level, BlockPos pos) {
            BlockState up = level.getBlockState(pos.above());
            float hardness = 2.0f;
            Block block = up.getBlock();
            if (block instanceof BlockWithDynamicHardness) {
                BlockWithDynamicHardness upBlock = (BlockWithDynamicHardness)block;
                hardness = upBlock.getHardness(up, level, pos.above());
            }
            return (float)((double)hardness * Services.CONFIG.getDoubleConfig("rootyBlockHardnessMultiplier"));
        }

        @Override
        public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
            int radius = (Integer)state.getValue((Property)RADIUS);
            return Block.box((double)(8 - radius), (double)0.0, (double)(8 - radius), (double)(radius + 8), (double)16.0, (double)(radius + 8));
        }

        @Override
        protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
            return this.getShape(state, level, pos, context);
        }

        @Override
        protected VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
            return this.getShape(state, level, pos, context);
        }

        @Override
        protected VoxelShape getBlockSupportShape(BlockState state, BlockGetter level, BlockPos pos) {
            return this.getShape(state, level, pos, CollisionContext.empty());
        }

        @Override
        public int getRadius(BlockState state) {
            return (Integer)state.getValue((Property)RADIUS);
        }

        public boolean isStructurallyUnstable(LevelAccessor level, BlockPos rootPos) {
            BlockPos belowPos = rootPos.below();
            RootIntegrityNode node = new RootIntegrityNode();
            BlockState belowState = level.getBlockState(belowPos);
            if (!TreeHelper.isTreePart(belowState)) {
                return true;
            }
            TreeHelper.getTreePart(belowState).analyse(belowState, level, belowPos, null, new MapSignal(node));
            return node.getStable().isEmpty();
        }

        @Override
        public boolean fallWithTree(BlockState state, Level level, BlockPos pos, boolean hasRoots) {
            if (hasRoots) {
                level.setBlock(pos, this.getDecayBlockStateAir(state, (BlockGetter)level, pos), 2);
                return true;
            }
            return false;
        }

        @Override
        protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
            if (!state.is((Block)this)) {
                return;
            }
            if (this.isStructurallyUnstable((LevelAccessor)level, pos)) {
                this.dropWholeTree((Level)level, pos, null, FallingTreeEntity.DestroyType.HARVEST);
            } else {
                this.updateRadius((LevelAccessor)level, state, pos, 3, false);
            }
            super.tick(level.getBlockState(pos), level, pos, random);
        }

        @Override
        public void updateTree(BlockState rootyState, Level level, BlockPos rootPos, RandomSource random, boolean natural) {
            int radOld = TreeHelper.getRadius((BlockGetter)level, rootPos.offset(this.getTrunkDirection((BlockGetter)level, rootPos).getNormal()));
            super.updateTree(rootyState, level, rootPos, random, natural);
            int radNew = TreeHelper.getRadius((BlockGetter)level, rootPos.offset(this.getTrunkDirection((BlockGetter)level, rootPos).getNormal()));
            if (radOld != radNew) {
                level.scheduleTick(rootPos, (Block)this, 1);
            }
        }

        public BlockState getDecayBlockStateAir(BlockState state, BlockGetter level, BlockPos pos) {
            if (state.hasProperty((Property)WATERLOGGED)) {
                return this.getFluidState(state).createLegacyBlock();
            }
            return Blocks.AIR.defaultBlockState();
        }

        @Override
        public BlockState getDecayBlockState(BlockState state, BlockGetter level, BlockPos pos) {
            BranchBlock branch = this.getSoilProperties().getFamily().getBranch().orElse(null);
            if (branch == null) {
                return super.getDecayBlockState(state, level, pos);
            }
            BlockState decay = branch.getStateForRadius(this.getRadius(state));
            if (state.hasProperty((Property)WATERLOGGED) && ((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() && decay.hasProperty((Property)WATERLOGGED)) {
                return (BlockState)decay.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
            }
            return decay;
        }

        @Override
        public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
            if (!level.isClientSide) {
                this.dropWholeTree(level, pos, player, FallingTreeEntity.DestroyType.HARVEST);
            }
            return level.isClientSide() ? level.setBlock(pos, fluid.createLegacyBlock(), 11) : level.removeBlock(pos, false);
        }

        public void dropWholeTree(Level level, BlockPos rootPos, @Nullable Player player, FallingTreeEntity.DestroyType destroyType) {
            Optional<BranchBlock> branch = TreeHelper.getBranchOpt(level.getBlockState(rootPos.above()));
            Optional<BranchBlock> roots = TreeHelper.getBranchOpt(level.getBlockState(rootPos.below()));
            BranchDestructionData destroyData = null;
            Optional<Object> toolDir = Optional.empty();
            if (player != null) {
                toolDir = Optional.of(EntityUtils.getHitDirection((LivingEntity)player));
            }
            if (toolDir.isPresent() && ((Direction)toolDir.get()).getAxis() == Direction.Axis.Y) {
                toolDir = Optional.empty();
            }
            Direction fallingDir = (Direction)toolDir.orElse(Direction.Plane.HORIZONTAL.getRandomDirection(level.getRandom()));
            if (branch.isPresent()) {
                destroyData = branch.get().destroyBranchFromNode(level, rootPos.above(), fallingDir, player == null, (LivingEntity)player);
            }
            if (roots.isPresent()) {
                BranchDestructionData rootDestroyData = roots.get().destroyBranchFromNode(level, rootPos.below(), fallingDir, player == null, (LivingEntity)player);
                destroyData = destroyData == null ? rootDestroyData : destroyData.merge(rootDestroyData);
            }
            if (destroyData != null) {
                ItemStack heldItem = player == null ? ItemStack.EMPTY : player.getMainHandItem();
                int fortune = ItemUtils.getEnchantmentLevel((ResourceKey<Enchantment>)Enchantments.FORTUNE, heldItem, level.registryAccess());
                float fortuneFactor = 1.0f + 0.25f * (float)fortune;
                NetVolumeNode.Volume woodVolume = destroyData.woodVolume;
                woodVolume.multiplyVolume(fortuneFactor);
                List<ItemStack> woodItems = destroyData.species.getBranchesDrops(level, woodVolume, heldItem);
                FallingTreeEntity.dropTree(level, destroyData, woodItems, destroyType);
                BlockState rootState = level.getBlockState(rootPos);
                if (player != null) {
                    ItemUtils.damageAxe((LivingEntity)player, heldItem, this.getRadius(rootState), woodVolume, true);
                }
                level.scheduleTick(rootPos, (Block)this, 9);
            }
        }

        @Override
        public int updateRadius(LevelAccessor level, BlockState state, BlockPos pos, int flags, boolean force) {
            if (!(state.getBlock() instanceof RootSoilBlock)) {
                return 8;
            }
            int upRad = TreeHelper.getRadius((BlockGetter)level, pos.above());
            if (upRad > 0) {
                int thisRad = (Integer)state.getValue((Property)RADIUS);
                if (upRad != thisRad || force) {
                    int newRadius = Math.min(upRad, 8);
                    level.setBlock(pos, (BlockState)state.setValue((Property)RADIUS, (Comparable)Integer.valueOf(newRadius)), flags);
                    return newRadius;
                }
                return upRad;
            }
            return 0;
        }
    }
}

