/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.command.subcommand;

import com.dtteam.dynamictrees.command.CommandHelper;
import com.dtteam.dynamictrees.command.subcommand.SubCommand;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public final class KillTreeCommand
extends SubCommand {
    @Override
    protected String getName() {
        return "killtree";
    }

    @Override
    protected int getPermissionLevel() {
        return 2;
    }

    @Override
    public ArgumentBuilder<CommandSourceStack, ?> registerArgument() {
        return KillTreeCommand.blockPosArgument().executes(context -> KillTreeCommand.executesSuccess(() -> this.killTree((CommandSourceStack)context.getSource(), KillTreeCommand.rootPosArgument((CommandContext<CommandSourceStack>)context))));
    }

    private void killTree(CommandSourceStack source, BlockPos rootPos) {
        ServerLevel level = source.getLevel();
        Objects.requireNonNull(TreeHelper.getRooty(level.getBlockState(rootPos))).destroyTree((Level)level, rootPos);
        KillTreeCommand.sendSuccessAndLog(source, (Component)Component.translatable((String)"commands.dynamictrees.success.kill_tree", (Object[])new Object[]{CommandHelper.posComponent((Vec3i)rootPos, ChatFormatting.AQUA)}));
    }
}

