/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.command.subcommand;

import com.dtteam.dynamictrees.api.worldgen.LevelContext;
import com.dtteam.dynamictrees.command.CommandConstants;
import com.dtteam.dynamictrees.command.CommandHelper;
import com.dtteam.dynamictrees.command.subcommand.SubCommand;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.utility.NullUtils;
import com.dtteam.dynamictrees.worldgen.DynamicTreeGenerationContext;
import com.dtteam.dynamictrees.worldgen.JoCode;
import com.dtteam.dynamictrees.worldgen.RootsJoCode;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;

public final class SetTreeCommand
extends SubCommand {
    private static final int DEFAULT_FERTILITY = 0;

    @Override
    protected String getName() {
        return "settree";
    }

    @Override
    protected int getPermissionLevel() {
        return 2;
    }

    @Override
    public ArgumentBuilder<CommandSourceStack, ?> registerArgument() {
        return SetTreeCommand.blockPosArgument().then(((RequiredArgumentBuilder)SetTreeCommand.speciesArgument().executes(context -> this.setTree((CommandSourceStack)context.getSource(), SetTreeCommand.blockPosArgument((CommandContext<CommandSourceStack>)context), SetTreeCommand.speciesArgument((CommandContext<CommandSourceStack>)context), "JP", 0, 0))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)SetTreeCommand.stringArgument("jo_code").suggests((context, builder) -> SharedSuggestionProvider.suggest((Iterable)SetTreeCommand.speciesArgument((CommandContext<CommandSourceStack>)context).getJoCodes().stream().map(JoCode::toString).collect(Collectors.toList()), (SuggestionsBuilder)builder)).executes(context -> this.setTree((CommandSourceStack)context.getSource(), SetTreeCommand.blockPosArgument((CommandContext<CommandSourceStack>)context), SetTreeCommand.speciesArgument((CommandContext<CommandSourceStack>)context), SetTreeCommand.stringArgument((CommandContext<CommandSourceStack>)context, "jo_code"), 0, 0))).then(((RequiredArgumentBuilder)SetTreeCommand.intArgument("turns").executes(context -> this.setTree((CommandSourceStack)context.getSource(), SetTreeCommand.blockPosArgument((CommandContext<CommandSourceStack>)context), SetTreeCommand.speciesArgument((CommandContext<CommandSourceStack>)context), SetTreeCommand.stringArgument((CommandContext<CommandSourceStack>)context, "jo_code"), SetTreeCommand.intArgument((CommandContext<CommandSourceStack>)context, "turns"), 0))).then(SetTreeCommand.intArgument("fertility").suggests(CommandConstants.FERTILITY_SUGGESTIONS).executes(context -> this.setTree((CommandSourceStack)context.getSource(), SetTreeCommand.blockPosArgument((CommandContext<CommandSourceStack>)context), SetTreeCommand.speciesArgument((CommandContext<CommandSourceStack>)context), SetTreeCommand.stringArgument((CommandContext<CommandSourceStack>)context, "jo_code"), SetTreeCommand.intArgument((CommandContext<CommandSourceStack>)context, "turns"), SetTreeCommand.intArgument((CommandContext<CommandSourceStack>)context, "fertility")))))).then(((RequiredArgumentBuilder)SetTreeCommand.stringArgument("roots_jo_code").suggests((context, builder) -> SharedSuggestionProvider.suggest((Iterable)SetTreeCommand.speciesArgument((CommandContext<CommandSourceStack>)context).getRootsJoCodes().stream().map(JoCode::toString).collect(Collectors.toList()), (SuggestionsBuilder)builder)).executes(context -> this.setTreeWithRoots((CommandSourceStack)context.getSource(), SetTreeCommand.blockPosArgument((CommandContext<CommandSourceStack>)context), SetTreeCommand.speciesArgument((CommandContext<CommandSourceStack>)context), SetTreeCommand.stringArgument((CommandContext<CommandSourceStack>)context, "jo_code"), SetTreeCommand.stringArgument((CommandContext<CommandSourceStack>)context, "roots_jo_code"), 0, 0))).then(((RequiredArgumentBuilder)SetTreeCommand.intArgument("turns").suggests(CommandConstants.TURNS_SUGGESTIONS).executes(context -> this.setTreeWithRoots((CommandSourceStack)context.getSource(), SetTreeCommand.blockPosArgument((CommandContext<CommandSourceStack>)context), SetTreeCommand.speciesArgument((CommandContext<CommandSourceStack>)context), SetTreeCommand.stringArgument((CommandContext<CommandSourceStack>)context, "jo_code"), SetTreeCommand.stringArgument((CommandContext<CommandSourceStack>)context, "roots_jo_code"), SetTreeCommand.intArgument((CommandContext<CommandSourceStack>)context, "turns"), 0))).then(SetTreeCommand.intArgument("fertility").suggests(CommandConstants.FERTILITY_SUGGESTIONS).executes(context -> this.setTreeWithRoots((CommandSourceStack)context.getSource(), SetTreeCommand.blockPosArgument((CommandContext<CommandSourceStack>)context), SetTreeCommand.speciesArgument((CommandContext<CommandSourceStack>)context), SetTreeCommand.stringArgument((CommandContext<CommandSourceStack>)context, "jo_code"), SetTreeCommand.stringArgument((CommandContext<CommandSourceStack>)context, "roots_jo_code"), SetTreeCommand.intArgument((CommandContext<CommandSourceStack>)context, "turns"), SetTreeCommand.intArgument((CommandContext<CommandSourceStack>)context, "fertility"))))))));
    }

    private int setTree(CommandSourceStack source, BlockPos rootPos, Species species, String codeString, int turns, int fertility) {
        ServerLevel level = source.getLevel();
        JoCode joCode = species.getJoCode(codeString).rotate(Direction.from2DDataValue((int)(3 - turns % 4 + 3))).setCareful(true);
        SetTreeCommand.sendSuccessAndLog(source, (Component)Component.translatable((String)"commands.dynamictrees.success.set_tree", (Object[])new Object[]{CommandHelper.posComponent((Vec3i)rootPos), species.getTextComponent(), joCode.getTextComponent()}));
        DynamicTreeGenerationContext context = new DynamicTreeGenerationContext(LevelContext.create((LevelAccessor)level), species, rootPos, rootPos.mutable(), (Holder<Biome>)source.getLevel().getBiome(rootPos), Direction.SOUTH, 8, false);
        joCode.generate(context);
        NullUtils.consumeIfNonnull(TreeHelper.getRooty(level.getBlockState(rootPos)), rootyBlock -> rootyBlock.setFertility((Level)level, rootPos, fertility));
        return 1;
    }

    private int setTreeWithRoots(CommandSourceStack source, BlockPos rootPos, Species species, String codeString, String rootsCodeString, int turns, int fertility) {
        RootsJoCode rootsJoCode = species.getRootsJoCode(rootsCodeString);
        if (!species.getFamily().hasRootSystem()) {
            SetTreeCommand.sendFailure(source, (Component)Component.translatable((String)"commands.dynamictrees.error.no_roots", (Object[])new Object[]{species.getTextComponent(), rootsJoCode.getTextComponent()}));
            return 0;
        }
        ServerLevel level = source.getLevel();
        Direction dir = Direction.from2DDataValue((int)(3 - turns % 4 + 3));
        JoCode joCode = species.getJoCode(codeString).rotate(dir).setCareful(true);
        rootsJoCode.rotate(dir).setCareful(true);
        SetTreeCommand.sendSuccessAndLog(source, (Component)Component.translatable((String)"commands.dynamictrees.success.set_tree_roots", (Object[])new Object[]{CommandHelper.posComponent((Vec3i)rootPos), species.getTextComponent(), joCode.getTextComponent(), rootsJoCode.getTextComponent()}));
        DynamicTreeGenerationContext context = new DynamicTreeGenerationContext(LevelContext.create((LevelAccessor)level), species, rootPos, rootPos.mutable(), (Holder<Biome>)source.getLevel().getBiome(rootPos), Direction.SOUTH, 8, false);
        joCode.generate(context);
        ((JoCode)rootsJoCode).generate(context);
        NullUtils.consumeIfNonnull(TreeHelper.getRooty(level.getBlockState(rootPos)), rootyBlock -> rootyBlock.setFertility((Level)level, rootPos, fertility));
        return 1;
    }
}

