/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.compat.waila;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.api.network.MapSignal;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.branch.TrunkShellBlock;
import com.dtteam.dynamictrees.block.fruit.Fruit;
import com.dtteam.dynamictrees.block.pod.Pod;
import com.dtteam.dynamictrees.compat.WailaHelper;
import com.dtteam.dynamictrees.systems.nodemapper.NetVolumeNode;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.utility.ItemUtils;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.impl.ui.ElementHelper;

public class WailaBranchHandler
implements IBlockComponentProvider {
    public static final ResourceLocation ID = DynamicTrees.location("branch");
    private BlockPos lastPos = BlockPos.ZERO;
    private Species lastSpecies = Species.NULL_SPECIES;
    private NetVolumeNode.Volume lastVolume = new NetVolumeNode.Volume();

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (WailaHelper.invalid) {
            this.lastPos = BlockPos.ZERO;
            this.lastSpecies = Species.NULL_SPECIES;
            this.lastVolume = new NetVolumeNode.Volume();
            WailaHelper.invalid = false;
        }
        CompoundTag nbtData = accessor.getServerData();
        BlockPos pos = accessor.getPosition();
        Species species = Species.NULL_SPECIES;
        if (nbtData.contains("species")) {
            species = Species.findSpecies(ResourceLocation.parse((String)nbtData.getString("species")));
        }
        if (species == Species.NULL_SPECIES && this.lastPos.equals((Object)pos)) {
            species = this.lastSpecies;
        }
        if (species == Species.NULL_SPECIES) {
            species = this.getWailaSpecies(accessor.getLevel(), pos);
        }
        if (!species.useDefaultWailaBody()) {
            return;
        }
        if (!this.lastPos.equals((Object)pos)) {
            this.lastVolume = this.getTreeVolume(accessor.getLevel(), pos, species);
        }
        this.lastSpecies = species;
        this.lastPos = pos;
        if (species != Species.NULL_SPECIES) {
            if (species.showSpeciesOnWaila()) {
                tooltip.add((Component)Component.translatable((String)"tooltip.dynamictrees.species", (Object[])new Object[]{species.getTextComponent()}));
            }
            if (Minecraft.getInstance().options.advancedItemTooltips) {
                tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.DARK_GRAY) + species.getRegistryName().toString())));
            }
            ItemStack seedStack = species.getSeedStack(1);
            LinkedList<IElement> elements = new LinkedList<IElement>();
            elements.add(WailaBranchHandler.getElement(seedStack));
            if (species.hasFruits()) {
                for (Fruit fruit : species.getFruits()) {
                    ItemStack fruitStack = fruit.getItemStack();
                    if (fruitStack.getItem() == seedStack.getItem()) continue;
                    elements.add(WailaBranchHandler.getElement(fruitStack));
                }
            }
            if (species.hasPods()) {
                for (Pod pod : species.getPods()) {
                    ItemStack podStack = pod.getItemStack();
                    if (podStack.getItem() == seedStack.getItem()) continue;
                    elements.add(WailaBranchHandler.getElement(podStack));
                }
            }
            int silkTouch = ItemUtils.getEnchantmentLevel((ResourceKey<Enchantment>)Enchantments.SILK_TOUCH, accessor.getPlayer().getMainHandItem(), accessor.getPlayer().registryAccess());
            int fortune = ItemUtils.getEnchantmentLevel((ResourceKey<Enchantment>)Enchantments.FORTUNE, accessor.getPlayer().getMainHandItem(), accessor.getPlayer().registryAccess());
            if (this.lastVolume.getVolume() > 0.0f) {
                ItemStack stickStack;
                Species.LogsAndSticks las = species.getLogsAndSticks(this.lastVolume, silkTouch > 0, fortune);
                List<ItemStack> logStacks = las.logs;
                if (!logStacks.isEmpty()) {
                    for (ItemStack logStack : logStacks) {
                        elements.add(WailaBranchHandler.getElement(logStack));
                    }
                }
                if (las.sticks > 0 && !(stickStack = species.getFamily().getStick(las.sticks)).isEmpty()) {
                    elements.add(WailaBranchHandler.getElement(stickStack));
                }
            }
            tooltip.add((IElement)elements.removeFirst());
            elements.forEach(arg_0 -> ((ITooltip)tooltip).append(arg_0));
            tooltip.add(ElementHelper.INSTANCE.spacer(0, 2));
        }
    }

    private NetVolumeNode.Volume getTreeVolume(Level level, BlockPos pos, Species species) {
        TrunkShellBlock.ShellMuse muse;
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof TrunkShellBlock && (muse = ((TrunkShellBlock)block).getMuse((BlockGetter)level, pos)) != null) {
            state = muse.state();
            block = state.getBlock();
            pos = muse.pos();
        }
        if (block instanceof BranchBlock) {
            BranchBlock branch = (BranchBlock)block;
            NetVolumeNode volumeSum = new NetVolumeNode();
            branch.analyse(state, (LevelAccessor)level, pos, null, new MapSignal(volumeSum));
            NetVolumeNode.Volume volume = volumeSum.getVolume();
            species.processVolume(volume);
            return volume;
        }
        return new NetVolumeNode.Volume();
    }

    private Species getWailaSpecies(Level level, BlockPos pos) {
        return TreeHelper.getBestGuessSpecies(level, pos);
    }

    private static IElement getElement(ItemStack stack) {
        if (!stack.isEmpty()) {
            return ElementHelper.INSTANCE.item(stack);
        }
        return ElementHelper.INSTANCE.spacer(0, 0);
    }

    public ResourceLocation getUid() {
        return ID;
    }
}

