/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.config;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.event.handler.OptionalHandlers;
import com.dtteam.dynamictrees.systems.season.SeasonCompatibilityHandler;
import com.dtteam.dynamictrees.tree.species.SwampSpecies;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="dynamictrees", bus=EventBusSubscriber.Bus.MOD)
public class DTConfigs {
    public static final File CONFIG_DIRECTORY;
    public static final Map<String, ModConfigSpec.ConfigValue<?>> CONFIGS;
    public static final ModConfigSpec SERVER_CONFIG;
    public static final ModConfigSpec COMMON_CONFIG;
    public static final ModConfigSpec CLIENT_CONFIG;

    private static <V, T extends ModConfigSpec.ConfigValue<V>> T registerConfig(T config) {
        CONFIGS.put((String)config.getPath().getLast(), config);
        return config;
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading event) {
        OptionalHandlers.configReload();
        SeasonCompatibilityHandler.reloadSeasonManager();
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading event) {
        OptionalHandlers.configReload();
        SeasonCompatibilityHandler.reloadSeasonManager();
    }

    static {
        CONFIGS = new HashMap();
        CONFIG_DIRECTORY = new File(FMLPaths.CONFIGDIR.get().toUri());
        ModConfigSpec.Builder SERVER_BUILDER = new ModConfigSpec.Builder();
        ModConfigSpec.Builder COMMON_BUILDER = new ModConfigSpec.Builder();
        ModConfigSpec.Builder CLIENT_BUILDER = new ModConfigSpec.Builder();
        SERVER_BUILDER.comment("Seed Settings").push("seeds");
        DTConfigs.registerConfig(SERVER_BUILDER.comment("The rate at which seeds drop from leaves.").defineInRange("leavesSeedDropRate", 1.0, 0.0, 64.0));
        DTConfigs.registerConfig(SERVER_BUILDER.comment("The minimum chance for seed dropping from leaves when a seasonal mod is installed. 0 = during the off season seeds never drop from leaves, 1 = seeds will drop at maximum rate during the entire year. Can be fractional.").defineInRange("minSeasonalLeavesSeedDropRate", 0.15, 0.0, 1.0));
        DTConfigs.registerConfig(SERVER_BUILDER.comment("The rate at which seeds voluntarily drop from branches").defineInRange("voluntarySeedDropRate", 0.01, 0.0, 1.0));
        DTConfigs.registerConfig(SERVER_BUILDER.comment("The minimum chance for seed dropping voluntarily when a seasonal mod is installed. 0 = during the off season seeds never drop voluntarily, 1 = seeds will drop at maximum rate during the entire year. Can be fractional.").defineInRange("minSeasonalVoluntarySeedDropRate", 0.0, 0.0, 1.0));
        DTConfigs.registerConfig(SERVER_BUILDER.comment("The rate at which seeds voluntarily plant themselves in their ideal biomes").defineInRange("seedPlantRate", 0.1666666716337204, 0.0, 1.0));
        DTConfigs.registerConfig(SERVER_BUILDER.comment("Ticks before a seed in the world attempts to plant itself or despawn. 1200 = 1 minute").defineInRange("seedTimeToLive", 1200, 0, 6000));
        DTConfigs.registerConfig(SERVER_BUILDER.comment("If enabled then seeds will only voluntarily plant themselves in forest-like biomes.").define("seedOnlyForest", true));
        DTConfigs.registerConfig(SERVER_BUILDER.comment("The minimum forestness that non-forest-like biomes can have. 0 = is not at all a forest, 1 = may as well be a forest. Can be fractional.").defineInRange("seedMinForestness", 0.0, 0.0, 1.0));
        DTConfigs.registerConfig(SERVER_BUILDER.comment("If enabled, fruit and pod production will be affected by the current biome's climate.").define("climateAffectsFruitsAndPods", true));
        SERVER_BUILDER.pop();
        SERVER_BUILDER.comment("Tree Settings").push("trees");
        DTConfigs.registerConfig(SERVER_BUILDER.comment("Factor that multiplies the rate at which trees grow. Use at own risk").defineInRange("treeGrowthMultiplier", 0.5, 0.0, 16.0));
        DTConfigs.registerConfig(SERVER_BUILDER.comment("Factor that multiplies the wood returned from harvesting a tree.  You cheat.").defineInRange("treeHarvestMultiplier", 1.0, 0.0, 128.0));
        DTConfigs.registerConfig(SERVER_BUILDER.comment("Maximum harvesting hardness that can be calculated. Regardless of tree thickness.").defineInRange("maxTreeHardness", 20.0, 1.0, 200.0));
        DTConfigs.registerConfig(SERVER_BUILDER.comment("A multiplier of tree hardness. Higher values make trees slower to chop, lower values makes them faster to chop.").defineInRange("treeHardnessMultiplier", 1.0, 0.0078125, 32.0));
        DTConfigs.registerConfig(SERVER_BUILDER.comment("If enabled then sticks will be dropped for partial logs").define("dropSticks", true));
        DTConfigs.registerConfig(SERVER_BUILDER.comment("Scales the growth for the environment.  0.5f is nominal. 0.0 trees only grow in their native biome. 1.0 trees grow anywhere like they are in their native biome").defineInRange("scaleBiomeGrowthRate", 0.5, 0.0, 1.0));
        DTConfigs.registerConfig(SERVER_BUILDER.comment("The chance of a tree on depleted soil to die. 1/256(~0.004) averages to about 1 death every 16 minecraft days").defineInRange("diseaseChance", 0.0, 0.0, 1.0));
        DTConfigs.registerConfig(SERVER_BUILDER.comment("The maximum radius of a branch that is allowed to postRot away. 8 = Full block size. 24 = Full 3x3 thick size. Set to 0 to prevent rotting").defineInRange("maxBranchRotRadius", 7, 0, 24));
        DTConfigs.registerConfig(SERVER_BUILDER.comment("How much harder it is to destroy a rooty block compared to its non-rooty state").defineInRange("rootyBlockHardnessMultiplier", 40.0, 0.0, 128.0));
        DTConfigs.registerConfig(SERVER_BUILDER.comment("Options for how oak trees generate in swamps. ROOTED: Swamp oak trees will generate on shallow water with mangrove-like roots. SUNK: Swamp oak trees will generate on shallow water one block under the surface. DISABLED: Swamp oaks will not generate on water.").defineEnum("swampOaksInWater", (Enum)SwampSpecies.WaterSurfaceGenerationState.ROOTED));
        DTConfigs.registerConfig(SERVER_BUILDER.comment("The amount of growth pulses to send when bone meal is applied to a tree. Warning: setting values higher than 64 is not recommended other than for testing purposes. ").defineInRange("boneMealGrowthPulses", 1, 1, 512));
        SERVER_BUILDER.pop();
        SERVER_BUILDER.comment("Interaction Settings").push("interaction");
        DTConfigs.registerConfig(SERVER_BUILDER.comment("If enabled all leaves will be passable. If the Passable Foliage mod is installed this config is overridden").define("isLeavesPassable", false));
        DTConfigs.registerConfig(SERVER_BUILDER.comment("If enabled player movement on leaves will not be enhanced").define("vanillaLeavesCollision", false));
        DTConfigs.registerConfig(SERVER_BUILDER.comment("If enabled then thinner branches can be climbed").define("enableBranchClimbing", true));
        DTConfigs.registerConfig(SERVER_BUILDER.comment("If enabled players receive reduced fall damage on leaves at the expense of the block(s) destruction").define("enableCanopyCrash", true));
        DTConfigs.registerConfig(SERVER_BUILDER.comment("Damage dealt to the axe item when cutting a tree down. VANILLA: Standard 1 Damage. THICKNESS: By Branch/Trunk Thickness. VOLUME: By Tree Volume.").defineEnum("axeDamageMode", (Enum)DynamicTrees.AxeDamage.THICKNESS));
        DTConfigs.registerConfig(SERVER_BUILDER.comment("If enabled then trees will fall over when harvested").define("enableFallingTrees", true));
        DTConfigs.registerConfig(SERVER_BUILDER.comment("If enabled then trees will harm living entities when falling").define("enableFallingTreeDamage", true));
        DTConfigs.registerConfig(SERVER_BUILDER.comment("Multiplier for damage incurred by a falling tree").defineInRange("fallingTreeDamageMultiplier", 1.0, 0.0, 100.0));
        DTConfigs.registerConfig(SERVER_BUILDER.comment("If enabled the Dirt Bucket will place a dirt block on right-click").define("dirtBucketPlacesDirt", true));
        DTConfigs.registerConfig(SERVER_BUILDER.comment("If enabled then improperly broken trees(not by an entity) will still drop wood.").define("sloppyBreakDrops", false));
        DTConfigs.registerConfig(SERVER_BUILDER.comment("The minimum radius a branch must have before its able to be stripped. 8 = Full block size. Set to 0 to disable stripping trees").defineInRange("minRadiusForStrip", 6, 0, 24));
        DTConfigs.registerConfig(SERVER_BUILDER.comment("If enabled, stripping a branch will decrease its radius by one").define("enableStripRadiusReduction", true));
        DTConfigs.registerConfig(SERVER_BUILDER.comment("Sets the default for whether or not fruit growing from dynamic trees can be bone-mealed. Note that this is a default; it can be overridden by the individual fruit.").define("canBoneMealFruit", false));
        DTConfigs.registerConfig(SERVER_BUILDER.comment("Sets the default for whether or not pods growing from dynamic trees can be bone-mealed. Note that this is a default; it can be overridden by the individual pod.").define("canBoneMealPods", true));
        DTConfigs.registerConfig(SERVER_BUILDER.comment("If enabled, dynamic sapling blocks will drop their seed when broken.").define("dynamicSaplingDrops", true));
        SERVER_BUILDER.pop();
        COMMON_BUILDER.comment("Vanilla Trees Settings").push("vanilla");
        DTConfigs.registerConfig(COMMON_BUILDER.comment("Right clicking with a vanilla sapling places a dynamic sapling instead.").define("replaceVanillaSaplings", false));
        DTConfigs.registerConfig(COMMON_BUILDER.comment("Crimson Fungus and Warped Fungus that sprout from nylium will be dynamic instead.").define("replaceNyliumFungi", true));
        DTConfigs.registerConfig(COMMON_BUILDER.comment("If enabled, cancels the non-dynamic trees that spawn with vanilla villages.").define("cancelVanillaVillageTrees", true));
        DTConfigs.registerConfig(COMMON_BUILDER.comment("The maximum number of leaves blocks that will fling particles when a falling tree crashes into the ground. Higher values might have a performance impact.").defineInRange("maxFallingTreeLeavesParticles", 400, 0, 4096));
        COMMON_BUILDER.pop();
        SERVER_BUILDER.comment("World Generation Settings").push("world");
        DTConfigs.registerConfig(SERVER_BUILDER.comment("Randomly generate podzol under select trees like spruce.").define("generatePodzol", true));
        DTConfigs.registerConfig(SERVER_BUILDER.comment("World Generation produces Dynamic Trees instead of Vanilla trees.").define("worldGen", true));
        DTConfigs.registerConfig(SERVER_BUILDER.comment("Blacklist of dimension registry names for disabling Dynamic Tree worldgen").define("dimensionsBlacklist", new ArrayList()));
        SERVER_BUILDER.pop();
        COMMON_BUILDER.comment("Miscellaneous Settings").push("misc");
        DTConfigs.registerConfig(COMMON_BUILDER.comment("If enabled, dirt bucket recipes will be automatically generated.").define("generateDirtBucketRecipes", true));
        DTConfigs.registerConfig(COMMON_BUILDER.comment("If enabled, seeds for mega species can be crafted with four regular seeds.").define("generateMegaSeedRecipe", false));
        DTConfigs.registerConfig(COMMON_BUILDER.comment("The base potion the Biochar Base is brewed from. Minecraft potions use 'awkward'. If you change this, don't forget to update the patchouli manual page too.").define("biocharBrewingBase", (Object)"minecraft:thick"));
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Mod Integration Settings").push("integration");
        DTConfigs.registerConfig(COMMON_BUILDER.comment("The mod ID of preferred season mod. If a season provider for this mod ID is present, it will be used for integration with seasons. Set this to \"!\" to disable integration or \"*\" to accept the any integration (the first available).").define("preferredSeasonMod", (Object)"*"));
        DTConfigs.registerConfig(COMMON_BUILDER.comment("If enabled, seed drop rates will be multiplied based on the current season (requires serene seasons).").define("enableSeasonalSeedDropFactor", true));
        DTConfigs.registerConfig(COMMON_BUILDER.comment("If enabled, growth rates will be multiplied based on the current season (requires serene seasons).").define("enableSeasonalGrowthFactor", true));
        DTConfigs.registerConfig(COMMON_BUILDER.comment("If enabled, fruit production rates will be multiplied based on the current season (requires serene seasons).").define("enableSeasonalFruitProductionFactor", true));
        DTConfigs.registerConfig(COMMON_BUILDER.comment("The seasonal offset of the wet season relative to summer. Tropical and arid climates use wet/dry seasons instead of regular summer/fall/winter/spring seasons. Tree growth and fruit production usually peak during the wet season. If set to 0.0 the wet season happens at the same time as summer. The default of 2.5 means it happens between fall and winter.").defineInRange("wetSeasonOffset", 2.5, 0.0, 4.0));
        COMMON_BUILDER.pop();
        SERVER_BUILDER.comment("Debug Settings").push("debug");
        DTConfigs.registerConfig(SERVER_BUILDER.comment("Enable to mark tree spawn locations with concrete circles.").define("debug", false));
        SERVER_BUILDER.pop();
        SERVER_CONFIG = SERVER_BUILDER.build();
        COMMON_CONFIG = COMMON_BUILDER.build();
        CLIENT_CONFIG = CLIENT_BUILDER.build();
    }
}

