/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.data.generator;

import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.data.DTDataProvider;
import com.dtteam.dynamictrees.data.Generator;
import com.dtteam.dynamictrees.data.builder.BranchLoaderBuilder;
import com.dtteam.dynamictrees.data.provider.DTBlockStateProvider;
import com.dtteam.dynamictrees.tree.family.Family;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;

public class BranchStateGenerator
implements Generator<DTDataProvider.BlockState, Family> {
    public static final Generator.DependencyKey<BranchBlock> BRANCH = new Generator.DependencyKey("branch");
    public static final Generator.DependencyKey<Block> PRIMITIVE_LOG = new Generator.DependencyKey("primitive_log");

    @Override
    public void generate(DTDataProvider.BlockState prov, Family input, Generator.Dependencies dependencies) {
        if (prov instanceof DTBlockStateProvider) {
            DTBlockStateProvider provider = (DTBlockStateProvider)prov;
            BranchBlock branch = dependencies.get(BRANCH);
            BranchLoaderBuilder builder = (BranchLoaderBuilder)((BlockModelBuilder)provider.models().getBuilder(Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)branch)).getPath())).customLoader(BranchLoaderBuilder.branchBuilders.get(input.getBranchLoader()));
            Block block = dependencies.get(PRIMITIVE_LOG);
            input.addBranchTextures(builder::texture, provider.block(BuiltInRegistries.BLOCK.getKey((Object)block)), block);
            provider.simpleBlock(branch, (ModelFile)builder.end());
        }
    }

    @Override
    public Generator.Dependencies gatherDependencies(Family input) {
        return new Generator.Dependencies().append(BRANCH, input.getBranch()).append(PRIMITIVE_LOG, input.getPrimitiveLog());
    }
}

