/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.data.generator;

import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.data.DTDataProvider;
import com.dtteam.dynamictrees.data.Generator;
import com.dtteam.dynamictrees.data.provider.DTLangProvider;
import com.dtteam.dynamictrees.tree.species.Species;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.StringUtils;

public class LeavesPropertiesLangGenerator
implements Generator<DTDataProvider.Language, LeavesProperties> {
    DTLangProvider provider;

    @Override
    public void generate(DTDataProvider.Language prov, LeavesProperties input, Generator.Dependencies dependencies) {
        if (prov instanceof DTLangProvider) {
            DTLangProvider provider1;
            this.provider = provider1 = (DTLangProvider)prov;
        }
    }

    @Override
    public Generator.Dependencies gatherDependencies(LeavesProperties input) {
        return new Generator.Dependencies();
    }

    protected void itemLang(Item entry, Optional<String> override) {
        if (!(entry instanceof BlockItem) || entry instanceof ItemNameBlockItem) {
            this.provider.addItem(() -> entry, override.orElse(this.checkReplace(BuiltInRegistries.ITEM.getKey((Object)entry))));
        }
    }

    protected void speciesLang(Species entry, Optional<String> override) {
        this.provider.add(entry.getLocalizedName(), override.orElse(this.checkReplace(entry.getRegistryName())));
    }

    protected void blockLang(Block entry, Optional<String> blah) {
        this.provider.addBlock(() -> entry, blah.orElse(this.checkReplace(BuiltInRegistries.BLOCK.getKey((Object)entry))));
    }

    protected String checkReplace(ResourceLocation registryObject) {
        return Arrays.stream(registryObject.getPath().split("_")).map(StringUtils::capitalize).filter(s -> !s.isBlank()).collect(Collectors.joining(" ")).trim();
    }
}

