/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.data.generator;

import com.dtteam.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.block.leaves.PalmLeavesProperties;
import com.dtteam.dynamictrees.data.DTDataProvider;
import com.dtteam.dynamictrees.data.Generator;
import com.dtteam.dynamictrees.data.builder.PalmLeavesLoaderBuilder;
import com.dtteam.dynamictrees.data.provider.DTBlockStateProvider;
import com.dtteam.dynamictrees.utility.ResourceLocationUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;

public class PalmLeavesStateGenerator
implements Generator<DTDataProvider.BlockState, LeavesProperties> {
    public static final Generator.DependencyKey<DynamicLeavesBlock> LEAVES = new Generator.DependencyKey("leaves");
    public static final Generator.DependencyKey<Block> PRIMITIVE_LEAVES = new Generator.DependencyKey("primitive_leaves");

    @Override
    public void generate(DTDataProvider.BlockState prov, LeavesProperties input, Generator.Dependencies dependencies) {
        if (prov instanceof DTBlockStateProvider) {
            DTBlockStateProvider provider = (DTBlockStateProvider)prov;
            ResourceLocation defaultFrondsTexture = provider.block(ResourceLocationUtils.suffix(input.getRegistryName(), "_frond"));
            ResourceLocation defaultCoreTexture = provider.block(ResourceLocationUtils.suffix(input.getRegistryName(), "_base"));
            PalmLeavesProperties palmInput = (PalmLeavesProperties)input;
            PalmLeavesLoaderBuilder frondBuilder = (PalmLeavesLoaderBuilder)((BlockModelBuilder)provider.models().getBuilder(palmInput.getFrondsModelName())).customLoader((b, e) -> PalmLeavesLoaderBuilder.fronds(palmInput.getFrondLoader(), b, e));
            palmInput.addFrondTextures(frondBuilder::texture, defaultFrondsTexture);
            BlockModelBuilder coreTopBuilder = (BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(palmInput.getCoreTopModelName())).parent((ModelFile)provider.models().getExistingFile(palmInput.getCoreTopSmartModelLocation()));
            palmInput.addFrondTextures((arg_0, arg_1) -> ((BlockModelBuilder)coreTopBuilder).texture(arg_0, arg_1), defaultFrondsTexture);
            BlockModelBuilder coreBottomBuilder = (BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(palmInput.getCoreBottomModelName())).parent((ModelFile)provider.models().getExistingFile(palmInput.getCoreBottomSmartModelLocation()));
            palmInput.addCoreTextures((arg_0, arg_1) -> ((BlockModelBuilder)coreBottomBuilder).texture(arg_0, arg_1), defaultCoreTexture);
            ModelFile.ExistingModelFile blockModel = provider.models().getExistingFile(palmInput.getModelPath("leaves").orElse(provider.block(BuiltInRegistries.BLOCK.getKey((Object)dependencies.get(PRIMITIVE_LEAVES)))));
            IntegerProperty distance = PalmLeavesProperties.DynamicPalmLeavesBlock.DISTANCE;
            IntegerProperty direction = PalmLeavesProperties.DynamicPalmLeavesBlock.DIRECTION;
            ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)provider.getMultipartBuilder((Block)dependencies.get(LEAVES)).part().modelFile((ModelFile)frondBuilder.end()).addModel()).condition((Property)distance, (Comparable[])new Integer[]{1, 2}).end().part().modelFile((ModelFile)coreTopBuilder).addModel()).condition((Property)distance, (Comparable[])new Integer[]{3}).end().part().modelFile((ModelFile)coreBottomBuilder).addModel()).condition((Property)distance, (Comparable[])new Integer[]{4}).end().part().modelFile((ModelFile)blockModel).addModel()).useOr().nestedGroup().condition((Property)direction, (Comparable[])new Integer[]{0}).condition((Property)distance, (Comparable[])new Integer[]{1, 2}).end().nestedGroup().condition((Property)distance, (Comparable[])new Integer[]{5, 6, 7}).end().end();
        }
    }

    @Override
    public Generator.Dependencies gatherDependencies(LeavesProperties input) {
        return new Generator.Dependencies().append(LEAVES, input.getDynamicLeavesBlock()).append(PRIMITIVE_LEAVES, input.getPrimitiveLeavesBlock());
    }
}

