/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.data.generator;

import com.dtteam.dynamictrees.block.branch.BasicRootsBlock;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.data.DTDataProvider;
import com.dtteam.dynamictrees.data.Generator;
import com.dtteam.dynamictrees.data.builder.BranchLoaderBuilder;
import com.dtteam.dynamictrees.data.provider.DTBlockStateProvider;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.family.UndergroundRootsFamily;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;

public class RootsStateGenerator
implements Generator<DTDataProvider.BlockState, Family> {
    public static final Generator.DependencyKey<BranchBlock> ROOT = new Generator.DependencyKey("root");
    public static final Generator.DependencyKey<Block> PRIMITIVE_ROOT = new Generator.DependencyKey("primitive_root");
    public static final Generator.DependencyKey<Block> PRIMITIVE_FILLED_ROOT = new Generator.DependencyKey("filled_primitive_root");
    public static final Generator.DependencyKey<Block> PRIMITIVE_COVERED_ROOT = new Generator.DependencyKey("covered_primitive_root");

    @Override
    public void generate(DTDataProvider.BlockState prov, Family input, Generator.Dependencies dependencies) {
        if (prov instanceof DTBlockStateProvider) {
            DTBlockStateProvider provider = (DTBlockStateProvider)prov;
            BranchBlock root = dependencies.get(ROOT);
            BranchLoaderBuilder builderExposed = (BranchLoaderBuilder)((BlockModelBuilder)provider.models().getBuilder(Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)root)).getPath())).customLoader(BranchLoaderBuilder.branchBuilders.get(input.getRootsLoader()));
            input.addRootTextures(builderExposed::texture, provider.block(BuiltInRegistries.BLOCK.getKey((Object)dependencies.get(PRIMITIVE_ROOT))));
            BranchLoaderBuilder builderFilled = (BranchLoaderBuilder)((BlockModelBuilder)provider.models().getBuilder(Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)root)).getPath() + "_filled")).customLoader(BranchLoaderBuilder.branchBuilders.get(input.getRootsLoader()));
            input.addRootTextures(builderFilled::texture, provider.block(BuiltInRegistries.BLOCK.getKey((Object)dependencies.get(PRIMITIVE_FILLED_ROOT))));
            ((VariantBlockStateBuilder)((VariantBlockStateBuilder)provider.getVariantBuilder(root).partialState().with(BasicRootsBlock.LAYER, (Comparable)((Object)BasicRootsBlock.Layer.EXPOSED)).modelForState().modelFile((ModelFile)((BlockModelBuilder)builderExposed.end()).renderType("cutout_mipped")).addModel()).partialState().with(BasicRootsBlock.LAYER, (Comparable)((Object)BasicRootsBlock.Layer.FILLED)).modelForState().modelFile((ModelFile)builderFilled.end()).addModel()).partialState().with(BasicRootsBlock.LAYER, (Comparable)((Object)BasicRootsBlock.Layer.COVERED)).modelForState().modelFile((ModelFile)provider.models().getExistingFile(input.getModelPath("covered_roots_block").orElse(provider.blockTexture(dependencies.get(PRIMITIVE_COVERED_ROOT))))).addModel();
        }
    }

    @Override
    public Generator.Dependencies gatherDependencies(Family input) {
        UndergroundRootsFamily mangroveInput = (UndergroundRootsFamily)input;
        return new Generator.Dependencies().append(ROOT, mangroveInput.getRoots()).append(PRIMITIVE_ROOT, mangroveInput.getPrimitiveRoots()).append(PRIMITIVE_FILLED_ROOT, mangroveInput.getPrimitiveFilledRoots()).append(PRIMITIVE_COVERED_ROOT, mangroveInput.getPrimitiveCoveredRoots());
    }
}

