/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.data.provider;

import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.fruit.Fruit;
import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.block.pod.Pod;
import com.dtteam.dynamictrees.event.DataGenerationStreamEvent;
import com.dtteam.dynamictrees.tree.species.Species;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class DTBlockLootSubProvider
extends BlockLootSubProvider {
    protected final HolderLookup.Provider registries;
    private final String modId;
    private final ExistingFileHelper fileHelper;

    protected DTBlockLootSubProvider(HolderLookup.Provider registries, String modId, ExistingFileHelper fileHelper) {
        super(Set.of(), FeatureFlagSet.of(), registries);
        this.registries = registries;
        this.modId = modId;
        this.fileHelper = fileHelper;
    }

    protected void generate() {
        Species.REGISTRY.dataGenerationStream(this.modId).forEach(this::addVoluntaryTable);
        BuiltInRegistries.BLOCK.stream().filter(block -> block instanceof BranchBlock).map(block -> (BranchBlock)block).filter(block -> BuiltInRegistries.BLOCK.getKey(block).getNamespace().equals(this.modId)).forEach(this::addBranchTable);
        LeavesProperties.REGISTRY.dataGenerationStream(this.modId).forEach(leavesProperties -> {
            this.addLeavesBlockTable((LeavesProperties)leavesProperties);
            this.addLeavesTable((LeavesProperties)leavesProperties);
        });
        Fruit.REGISTRY.dataGenerationStream(this.modId).forEach(this::addFruitBlockTable);
        Pod.REGISTRY.dataGenerationStream(this.modId).forEach(this::addPodBlockTable);
        ModLoader.postEvent((Event)new DataGenerationStreamEvent((LootTableSubProvider)this, this.modId, this.fileHelper, this.map, this.registries));
    }

    public void generate(@NotNull BiConsumer<ResourceKey<LootTable>, LootTable.Builder> output) {
        this.generate();
        this.map.forEach(output);
    }

    private void addVoluntaryTable(Species species) {
        ResourceLocation leavesTablePath;
        if (species.shouldGenerateVoluntaryDrops() && !this.fileHelper.exists(leavesTablePath = species.getVoluntaryDropsPath(), PackType.SERVER_DATA)) {
            this.map.put(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)leavesTablePath), species.createVoluntaryDrops(this.registries));
        }
    }

    private void addBranchTable(BranchBlock branchBlock) {
        ResourceLocation branchTablePath;
        if (branchBlock.shouldGenerateBranchDrops() && !this.fileHelper.exists(branchTablePath = branchBlock.getLootTableName(), PackType.SERVER_DATA)) {
            this.map.put(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)branchTablePath), branchBlock.createBranchDrops(this.registries));
        }
    }

    private void addLeavesBlockTable(LeavesProperties leavesProperties) {
        ResourceLocation leavesBlockTablePath;
        if (leavesProperties.shouldGenerateBlockDrops() && !this.fileHelper.exists(leavesBlockTablePath = leavesProperties.getBlockLootTableName(), PackType.SERVER_DATA)) {
            this.map.put(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)leavesBlockTablePath), leavesProperties.createBlockDrops(this.registries));
        }
    }

    private void addLeavesTable(LeavesProperties leavesProperties) {
        ResourceLocation leavesTablePath;
        if (leavesProperties.shouldGenerateDrops() && !this.fileHelper.exists(leavesTablePath = leavesProperties.getLootTableName(), PackType.SERVER_DATA)) {
            this.map.put(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)leavesTablePath), leavesProperties.createDrops(this.registries));
        }
    }

    private void addFruitBlockTable(Fruit fruit) {
        ResourceLocation fruitBlockTablePath;
        if (fruit.shouldGenerateBlockDrops() && !this.fileHelper.exists(fruitBlockTablePath = fruit.getBlockDropsPath(), PackType.SERVER_DATA)) {
            this.map.put(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)fruitBlockTablePath), fruit.createBlockDrops(this.registries));
        }
    }

    private void addPodBlockTable(Pod pod) {
        ResourceLocation fruitBlockTablePath;
        if (pod.shouldGenerateBlockDrops() && !this.fileHelper.exists(fruitBlockTablePath = pod.getBlockDropsPath(), PackType.SERVER_DATA)) {
            this.map.put(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)fruitBlockTablePath), pod.createBlockDrops(this.registries));
        }
    }
}

