/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.deserialization.applier;

import com.dtteam.dynamictrees.deserialization.applier.Applier;
import com.dtteam.dynamictrees.deserialization.applier.PropertyApplier;
import com.dtteam.dynamictrees.deserialization.applier.PropertyApplierResult;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class MultiPropertyApplier<T, I>
extends PropertyApplier<T, Object, I> {
    private final List<PropertyApplier<T, Object, I>> appliers = Lists.newLinkedList();

    @SafeVarargs
    public MultiPropertyApplier(String key, Class<T> objectClass, PropertyApplier<T, Object, I> ... appliers) {
        super(key, objectClass, (O object, V value) -> {});
        this.appliers.addAll(Arrays.asList(appliers));
    }

    public void addApplier(PropertyApplier<T, Object, I> applier) {
        this.appliers.add(applier);
    }

    @Override
    @Nullable
    protected PropertyApplierResult applyIfShould(T object, I input, Applier<T, Object> applier) {
        PropertyApplierResult applierResult;
        Iterator<PropertyApplier<T, Object, I>> iterator = this.appliers.iterator();
        while ((applierResult = this.applyNext(object, input, applier, iterator)) == null || applierResult.failed()) {
        }
        return applierResult;
    }

    @Nullable
    private PropertyApplierResult applyNext(T object, I input, Applier<T, Object> applier, Iterator<PropertyApplier<T, Object, I>> iterator) {
        if (!iterator.hasNext()) {
            return null;
        }
        return iterator.next().applyIfShould(object, input, applier);
    }
}

