/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.deserialization.deserializer;

import com.dtteam.dynamictrees.deserialization.JsonDeserializers;
import com.dtteam.dynamictrees.deserialization.deserializer.JsonDeserializer;
import com.dtteam.dynamictrees.deserialization.result.Result;
import com.google.gson.JsonElement;
import java.util.Locale;

public final class EnumDeserializer<T extends Enum<T>>
implements JsonDeserializer<T> {
    private final Class<T> enumType;

    public EnumDeserializer(Class<T> enumType) {
        this.enumType = enumType;
    }

    @Override
    public Result<T, JsonElement> deserialize(JsonElement jsonElement) {
        return JsonDeserializers.STRING.deserialize(jsonElement).map(enumStr -> Enum.valueOf(this.enumType, enumStr.toUpperCase(Locale.ENGLISH)), "Couldn't get enum " + String.valueOf(this.enumType) + " from value '{previous_value}'.");
    }
}

