/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.deserialization.deserializer;

import com.dtteam.dynamictrees.deserialization.JsonDeserializers;
import com.dtteam.dynamictrees.deserialization.deserializer.JsonDeserializer;
import com.dtteam.dynamictrees.deserialization.result.Result;
import com.google.gson.JsonElement;
import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

public final class ResourceLocationDeserializer
implements JsonDeserializer<ResourceLocation> {
    private final String defaultNamespace;

    public ResourceLocationDeserializer(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    @Override
    public Result<ResourceLocation, JsonElement> deserialize(JsonElement jsonElement) {
        return JsonDeserializers.STRING.deserialize(jsonElement).map(string -> string.toLowerCase(Locale.ENGLISH)).mapIfValid(ResourceLocationDeserializer::isValidResourceLocation, "Invalid resource location '{value}'. Namespace Constraints: [a-z0-9_.-] Path Constraints: [a-z0-9/._-]", this::decode);
    }

    public static boolean isValidResourceLocation(String loc) {
        ResourceLocation resLoc = ResourceLocation.parse((String)loc);
        return ResourceLocation.isValidNamespace((String)(StringUtils.isEmpty((CharSequence)resLoc.getNamespace()) ? "minecraft" : resLoc.getNamespace())) && ResourceLocation.isValidPath((String)resLoc.getPath());
    }

    private ResourceLocation decode(String resLocStr) {
        String[] namespaceAndPath = new String[]{this.defaultNamespace, resLocStr};
        int colonIndex = resLocStr.indexOf(58);
        if (colonIndex >= 0) {
            namespaceAndPath[1] = resLocStr.substring(colonIndex + 1);
            if (colonIndex >= 1) {
                namespaceAndPath[0] = resLocStr.substring(0, colonIndex);
            }
        }
        return ResourceLocation.fromNamespaceAndPath((String)namespaceAndPath[0], (String)namespaceAndPath[1]);
    }

    public static ResourceLocationDeserializer create() {
        return new ResourceLocationDeserializer("minecraft");
    }

    public static ResourceLocationDeserializer create(String defaultNamespace) {
        return new ResourceLocationDeserializer(defaultNamespace);
    }
}

