/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.deserialization.deserializer;

import com.dtteam.dynamictrees.block.CommonVoxelShapes;
import com.dtteam.dynamictrees.deserialization.DeserializationException;
import com.dtteam.dynamictrees.deserialization.JsonDeserializers;
import com.dtteam.dynamictrees.deserialization.JsonHelper;
import com.dtteam.dynamictrees.deserialization.ShapeFunctions;
import com.dtteam.dynamictrees.deserialization.deserializer.JsonDeserializer;
import com.dtteam.dynamictrees.deserialization.result.JsonResult;
import com.dtteam.dynamictrees.deserialization.result.Result;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Locale;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class VoxelShapeDeserializer
implements JsonDeserializer<VoxelShape> {
    @Override
    public Result<VoxelShape, JsonElement> deserialize(JsonElement input) {
        return JsonResult.forInput(input).mapIfType(String.class, name -> CommonVoxelShapes.SHAPES.getOrDefault(name.toLowerCase(Locale.ENGLISH), Shapes.block())).elseMapIfType(AABB.class, Shapes::create).elseMapIfType(JsonArray.class, this::deserializeArray).elseMapIfType(JsonObject.class, this::deserializeObject).elseTypeError();
    }

    private VoxelShape deserializeArray(JsonArray array) throws DeserializationException {
        VoxelShape shape = Shapes.empty();
        for (JsonElement element : array) {
            shape = Shapes.or((VoxelShape)((VoxelShape)JsonDeserializers.AABB.deserialize(element).map(Shapes::create).orElseThrow()), (VoxelShape)shape);
        }
        return shape;
    }

    private VoxelShape deserializeObject(JsonObject json) throws DeserializationException {
        return (VoxelShape)JsonResult.forInput((JsonElement)json).mapIfContains("function", String.class, functionId -> (VoxelShape)ShapeFunctions.calculateShape(functionId, (JsonElement)this.getParametersJson(json)).getOrThrow()).elseMapIfContains("shapes", JsonArray.class, shapes -> {
            BooleanOp operator = JsonHelper.getOrDefault(json, "operator", BooleanOp.class, BooleanOp.OR);
            return this.deserializeShapes(operator, (JsonArray)shapes);
        }).elseTypeError().orElseThrow();
    }

    private JsonObject getParametersJson(JsonObject json) {
        return JsonHelper.getOrDefault(json, "parameters", JsonObject.class, new JsonObject());
    }

    private VoxelShape deserializeShapes(BooleanOp operator, JsonArray shapes) throws DeserializationException {
        if (shapes.isEmpty()) {
            return Shapes.empty();
        }
        VoxelShape shape = this.deserialize(shapes.get(0)).orElseThrow();
        for (int i = 1; i < shapes.size(); ++i) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)this.deserialize(shapes.get(i)).orElseThrow(), (BooleanOp)operator);
        }
        return shape;
    }
}

