/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.deserialization.deserializer.worldgen;

import com.dtteam.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.dtteam.dynamictrees.deserialization.DeserializationException;
import com.dtteam.dynamictrees.deserialization.JsonDeserializers;
import com.dtteam.dynamictrees.deserialization.deserializer.worldgen.JsonBiomeDatabaseDeserializer;
import com.dtteam.dynamictrees.deserialization.result.JsonResult;
import com.dtteam.dynamictrees.deserialization.result.Result;
import com.dtteam.dynamictrees.tree.species.Species;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public final class SpeciesSelectorDeserializer
implements JsonBiomeDatabaseDeserializer<BiomePropertySelectors.SpeciesSelector> {
    @Override
    public Result<BiomePropertySelectors.SpeciesSelector, JsonElement> deserialize(JsonElement input) {
        return JsonResult.forInput(input).mapIfType(Species.class, this::readStatic).elseMapIfType(String.class, this::readStatic).elseMapIfType(JsonObject.class, this::readSelector).elseTypeError();
    }

    private BiomePropertySelectors.SpeciesSelector readStatic(Species species) {
        return new BiomePropertySelectors.StaticSpeciesSelector(new BiomePropertySelectors.SpeciesSelection(species));
    }

    private BiomePropertySelectors.SpeciesSelector readStatic(String string) throws DeserializationException {
        if (this.isDefault(string)) {
            return new BiomePropertySelectors.StaticSpeciesSelector();
        }
        throw new DeserializationException("\"" + string + "\" is not a supported parameter for a static species selector.");
    }

    private BiomePropertySelectors.SpeciesSelector readSelector(JsonObject object, Consumer<String> warningConsumer) throws DeserializationException {
        return (BiomePropertySelectors.SpeciesSelector)JsonResult.forInput((JsonElement)object).mapIfContains("static", JsonElement.class, input -> (BiomePropertySelectors.SpeciesSelector)JsonResult.forInput(input).mapIfType(Species.class, this::readStatic).elseMapIfType(String.class, this::readStatic).elseTypeError().forEachWarning(warningConsumer).orElseThrow()).elseMapIfContains("random", JsonElement.class, input -> this.getRandomSpeciesSelector((JsonElement)input, warningConsumer)).forEachWarning(warningConsumer).orElseThrow();
    }

    @Nullable
    private BiomePropertySelectors.SpeciesSelector getRandomSpeciesSelector(JsonElement input, Consumer<String> warningConsumer) throws DeserializationException {
        return (BiomePropertySelectors.SpeciesSelector)JsonDeserializers.JSON_OBJECT.deserialize(input).map(object -> {
            BiomePropertySelectors.RandomSpeciesSelector randomSelector = new BiomePropertySelectors.RandomSpeciesSelector();
            for (Map.Entry entry : object.entrySet()) {
                String speciesName = (String)entry.getKey();
                JsonDeserializers.INTEGER.deserialize((JsonElement)entry.getValue()).ifSuccessOrElseThrow(weight -> {
                    if (weight > 0) {
                        if (this.isDefault(speciesName)) {
                            randomSelector.add((int)weight);
                        } else {
                            Species.findSpeciesSloppy(speciesName).ifValid(species -> randomSelector.add((Species)species, (int)weight));
                        }
                    }
                }, warningConsumer);
            }
            if (randomSelector.getSize() < 1) {
                throw new DeserializationException("No species were selected in random selector '" + String.valueOf(input) + "'.");
            }
            return randomSelector;
        }).forEachWarning(warningConsumer).orElseThrow();
    }
}

