/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.deserialization.result;

import com.dtteam.dynamictrees.deserialization.DeserializationException;
import com.dtteam.dynamictrees.deserialization.result.Result;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractResult<T, I>
implements Result<T, I> {
    protected final I input;
    @Nullable
    protected final T value;
    @Nullable
    protected final String error;
    protected final List<String> warnings;

    public AbstractResult(I input, @Nullable T value, @Nullable String error) {
        this(input, value, error, Lists.newLinkedList());
    }

    public AbstractResult(I input, @Nullable T value, @Nullable String error, List<String> warnings) {
        this.input = input;
        this.value = value;
        this.error = error;
        this.warnings = warnings;
    }

    @Override
    public I getInput() {
        return this.input;
    }

    @Override
    public T get() throws NoSuchElementException {
        if (this.value == null) {
            throw new NoSuchElementException("No value present in deserialisation result.");
        }
        return this.value;
    }

    @Override
    public T orElse(T other) {
        return this.value == null ? other : this.value;
    }

    @Override
    public T orElseGet(Supplier<T> other) {
        return this.value == null ? other.get() : this.value;
    }

    @Override
    public T orElseThrow() throws DeserializationException {
        if (this.value == null) {
            throw DeserializationException.error(String.valueOf(this.error));
        }
        return this.value;
    }

    @Override
    @Nullable
    public String getError() {
        return this.error;
    }

    @Override
    public Result<T, I> forEachWarning(Consumer<String> action) {
        this.warnings.forEach(action);
        return this;
    }

    @Override
    public List<String> getWarnings() {
        return this.warnings;
    }

    @Override
    public boolean success() {
        return this.value != null;
    }
}

