/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.deserialization.result;

import com.dtteam.dynamictrees.deserialization.DeserializationException;
import com.dtteam.dynamictrees.deserialization.JsonDeserializers;
import com.dtteam.dynamictrees.deserialization.deserializer.JsonDeserializer;
import com.dtteam.dynamictrees.deserialization.result.AbstractResult;
import com.dtteam.dynamictrees.deserialization.result.MappedJsonResult;
import com.dtteam.dynamictrees.deserialization.result.MappedResult;
import com.dtteam.dynamictrees.deserialization.result.NullJsonResult;
import com.dtteam.dynamictrees.deserialization.result.Result;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class JsonResult<T>
extends AbstractResult<T, JsonElement> {
    public JsonResult(JsonElement input, @Nullable T value, @Nullable String error) {
        super(input, value, error);
    }

    public JsonResult(JsonElement input, @Nullable T value, @Nullable String error, List<String> warnings) {
        super(input, value, error, warnings);
    }

    @Override
    public Result<T, JsonElement> removeError() {
        return new JsonResult<Object>((JsonElement)this.input, this.value, null, (List<String>)this.warnings);
    }

    @Override
    public <V> MappedResult<V, JsonElement> map(Result.Mapper<T, V> mapper) {
        try {
            return this.value == null ? MappedJsonResult.mapErrorneous(this) : MappedJsonResult.map(mapper.apply(this.value, this.warnings::add), this);
        }
        catch (DeserializationException | RuntimeException e) {
            return MappedJsonResult.errorneousMap(e.getMessage(), this);
        }
    }

    @Override
    public <V> MappedResult<V, JsonElement> map(Result.Mapper<T, V> mapper, Predicate<V> validator, String invalidError) {
        if (this.value == null) {
            return MappedJsonResult.mapErrorneous(this);
        }
        try {
            Object value = mapper.apply(this.value, this.warnings::add);
            return validator.test(value) ? MappedJsonResult.map(value, this) : MappedJsonResult.errorneousMap(invalidError.replaceFirst("\\{}", this.value.toString()), this);
        }
        catch (DeserializationException e) {
            return MappedJsonResult.errorneousMap(e.getMessage(), this);
        }
    }

    @Override
    public <V> MappedResult<V, JsonElement> mapIfValid(Predicate<T> validator, String invalidError, Result.Mapper<T, V> mapper) {
        return this.value == null ? MappedJsonResult.mapErrorneous(this) : (validator.test(this.value) ? this.map(mapper, "Unexpected error occurred. This should not be possible.") : MappedJsonResult.errorneousMap(invalidError.replaceFirst("\\{}", this.value.toString()), this));
    }

    @Override
    public <V, N> MappedResult<N, JsonElement> mapIfType(Class<V> type, Result.Mapper<V, N> mapper) {
        return JsonDeserializers.getOrThrow(type).deserialize((JsonElement)this.input).map(mapper);
    }

    @Override
    public <E> MappedResult<List<E>, JsonElement> mapToListOfType(Class<E> elementType) {
        return JsonDeserializers.JSON_ARRAY.deserialize((JsonElement)this.input).map(array -> {
            JsonDeserializer deserialiser = JsonDeserializers.getOrThrow(elementType);
            LinkedList list = new LinkedList();
            for (JsonElement element : array) {
                list.add(deserialiser.deserialize(element).orElseThrow());
            }
            return list;
        });
    }

    @Override
    public <V, E> MappedResult<List<E>, JsonElement> mapEachIfArray(Class<V> elementType, Result.Mapper<V, E> mapper) {
        return JsonDeserializers.JSON_ARRAY.deserialize((JsonElement)this.input).map(array -> {
            JsonDeserializer deserialiser = JsonDeserializers.getOrThrow(elementType);
            LinkedList list = new LinkedList();
            for (JsonElement element : array) {
                list.add(mapper.apply(deserialiser.deserialize(element).orElseThrow(), this.warnings::add));
            }
            return list;
        });
    }

    @Override
    public <E, V> MappedResult<V, JsonElement> mapIfContains(String key, Class<E> type, Result.Mapper<E, V> mapper) {
        return JsonDeserializers.JSON_OBJECT.deserialize((JsonElement)this.input).map(object -> {
            JsonElement element = object.get(key);
            if (element == null) {
                throw new DeserializationException("No value for key \"" + key + "\".");
            }
            return mapper.apply(JsonDeserializers.getOrThrow(type).deserialize(element).orElseThrow(), this.warnings::add);
        });
    }

    @Override
    public <E, V> MappedResult<V, JsonElement> mapIfContains(String key, Class<E> type, Result.Mapper<E, V> mapper, V defaultValue) {
        return JsonDeserializers.JSON_OBJECT.deserialize((JsonElement)this.input).map(object -> {
            JsonElement element = object.get(key);
            if (element == null) {
                return defaultValue;
            }
            return mapper.apply(JsonDeserializers.getOrThrow(type).deserialize(element).orElseThrow(), this.warnings::add);
        });
    }

    public static JsonResult<JsonElement> forInput(JsonElement input) {
        return new JsonResult<Object>(input, null, null);
    }

    public static <T> JsonResult<T> success(JsonElement json, T value) {
        return new JsonResult<T>(json, value, null);
    }

    public static <T> JsonResult<T> nullSuccess(JsonElement json, T value) {
        return new NullJsonResult<T>(json, value, null);
    }

    public static <T> JsonResult<T> failure(JsonElement json, String error) {
        return JsonResult.failure(json, error, Lists.newArrayList());
    }

    public static <T> JsonResult<T> failure(JsonElement json, String error, List<String> warnings) {
        return new JsonResult<Object>(json, null, error, warnings);
    }

    public static <T> Result<T, JsonElement> from(DataResult<Pair<T, JsonElement>> dataResult, JsonElement input) {
        try {
            return (Result)dataResult.map(pair -> JsonResult.success((JsonElement)pair.getSecond(), pair.getFirst())).getOrThrow();
        }
        catch (RuntimeException e) {
            return JsonResult.failure(input, e.getMessage());
        }
    }
}

