/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.event.handler;

import com.dtteam.dynamictrees.api.worldgen.LevelContext;
import com.dtteam.dynamictrees.command.DTCommand;
import com.dtteam.dynamictrees.event.handler.ClientModEventHandler;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.recipe.DendroPotionRecipeHandler;
import com.dtteam.dynamictrees.systems.FutureBreak;
import com.dtteam.dynamictrees.systems.poissondisc.UniversalPoissonDiscProvider;
import com.dtteam.dynamictrees.systems.season.SeasonCompatibilityHandler;
import com.dtteam.dynamictrees.systems.season.SeasonHelper;
import com.dtteam.dynamictrees.treepack.Resources;
import com.dtteam.dynamictrees.worldgen.BiomeDatabases;
import com.dtteam.dynamictrees.worldgen.feature.DynamicTreeFeature;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.event.level.ChunkDataEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

@EventBusSubscriber(modid="dynamictrees")
public class CommonGameEventHandler {
    @SubscribeEvent
    public static void onPreLevelTick(LevelTickEvent.Pre event) {
        if (!event.getLevel().isClientSide()) {
            FutureBreak.process(event.getLevel());
        }
        SeasonHelper.updateTick(event.getLevel(), event.getLevel().getDayTime());
    }

    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load event) {
        if (event.getLevel().isClientSide()) {
            ClientModEventHandler.discoverWoodColors();
        } else {
            BiomeDatabases.populateBlacklistFromConfig();
        }
    }

    @SubscribeEvent
    public static void onLevelUnload(LevelEvent.Unload event) {
        LevelAccessor level = event.getLevel();
        if (!level.isClientSide()) {
            DynamicTreeFeature.DISC_PROVIDER.unloadWorld((ServerLevel)level);
        }
    }

    @SubscribeEvent
    public static void onChunkDataLoad(ChunkDataEvent.Load event) {
        if (!Services.CONFIG.getBoolConfig("worldGen").booleanValue()) {
            return;
        }
        LevelAccessor level = event.getLevel();
        if (level == null || level.isClientSide()) {
            return;
        }
        byte[] circleData = event.getData().getByteArray("GTCD");
        UniversalPoissonDiscProvider discProvider = DynamicTreeFeature.DISC_PROVIDER;
        ChunkPos chunkPos = event.getChunk().getPos();
        discProvider.setChunkPoissonData(LevelContext.create(level), chunkPos, circleData);
    }

    @SubscribeEvent
    public static void onChunkDataSave(ChunkDataEvent.Save event) {
        if (!Services.CONFIG.getBoolConfig("worldGen").booleanValue()) {
            return;
        }
        LevelContext levelContext = LevelContext.create(event.getLevel());
        UniversalPoissonDiscProvider discProvider = DynamicTreeFeature.DISC_PROVIDER;
        ChunkAccess chunk = event.getChunk();
        ChunkPos chunkPos = chunk.getPos();
        byte[] circleData = discProvider.getChunkPoissonData(levelContext, chunkPos);
        event.getData().putByteArray("GTCD", circleData);
        if (chunk instanceof LevelChunk && !((LevelChunk)chunk).loaded) {
            discProvider.unloadChunkPoissonData(levelContext, chunkPos);
        }
    }

    @SubscribeEvent
    public static void onServerStart(ServerStartingEvent event) {
        SeasonCompatibilityHandler.getSeasonManager().flushMappings();
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        new DTCommand().registerDTCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new Resources.ReloadListener(event.getServerResources().getRecipeManager()));
    }

    @SubscribeEvent
    public static void registerBrewingRecipes(RegisterBrewingRecipesEvent event) {
        DendroPotionRecipeHandler.getAllDendroRecipes().forEach(recipe -> event.getBuilder().addRecipe((IBrewingRecipe)recipe));
    }
}

