/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.loot;

import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.utility.ResourceLocationUtils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.world.level.storage.loot.LootTable;

public final class LootTableSupplier {
    private final String path;
    private final ResourceLocation name;
    private final ResourceLocation baseName;

    public LootTableSupplier(String basePath, ResourceLocation name) {
        this.path = basePath;
        this.name = name;
        this.baseName = ResourceLocationUtils.prefix(name, this.path);
    }

    public LootTable get(ReloadableServerRegistries.Holder lootTables, Species species) {
        LootTable speciesOverrideTable = lootTables.getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)this.getName(species)));
        if (speciesOverrideTable != LootTable.EMPTY) {
            return speciesOverrideTable;
        }
        return lootTables.getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)this.baseName));
    }

    public ResourceLocation getName(Species species) {
        ResourceLocation speciesName = species.getRegistryName();
        return ResourceLocationUtils.surround(this.name, this.path, "/" + speciesName.getNamespace() + "/" + speciesName.getPath());
    }

    public ResourceLocation getName() {
        return this.baseName;
    }
}

