/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.loot.condition;

import com.dtteam.dynamictrees.loot.DTLootContextParams;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.registry.DTRegistries;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public final class SeasonalSeedDropChance
implements LootItemCondition {
    public static final MapCodec<SeasonalSeedDropChance> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.EMPTY.forGetter(a -> Unit.INSTANCE)).apply((Applicative)instance, SeasonalSeedDropChance::new));

    private SeasonalSeedDropChance(Unit unit) {
    }

    public LootItemConditionType getType() {
        return DTRegistries.SEASONAL_SEED_DROP_CHANCE.get();
    }

    public boolean test(LootContext context) {
        Float seasonalSeedDropFactor = (Float)context.getParamOrNull(DTLootContextParams.SEASONAL_SEED_DROP_FACTOR);
        assert (seasonalSeedDropFactor != null);
        double minimumDropRate = Services.CONFIG.getDoubleConfig("minSeasonalLeavesSeedDropRate");
        double adjustedSeasonalSeedDropFactor = Math.min((double)seasonalSeedDropFactor.floatValue() + minimumDropRate, 1.0);
        return Services.CONFIG.getDoubleConfig("leavesSeedDropRate") * adjustedSeasonalSeedDropFactor > (double)context.getRandom().nextFloat();
    }

    public static LootItemCondition.Builder seasonalSeedDropChance() {
        return () -> new SeasonalSeedDropChance(Unit.INSTANCE);
    }
}

