/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.loot.entry;

import com.dtteam.dynamictrees.loot.DTLootContextParams;
import com.dtteam.dynamictrees.registry.DTRegistries;
import com.dtteam.dynamictrees.tree.species.Species;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public final class SeedItemLootPoolEntry
extends LootPoolSingletonContainer {
    public static final MapCodec<SeedItemLootPoolEntry> CODEC = RecordCodecBuilder.mapCodec(instance -> SeedItemLootPoolEntry.singletonFields((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, SeedItemLootPoolEntry::new));

    public SeedItemLootPoolEntry(int weight, int quality, List<LootItemCondition> conditions, List<LootItemFunction> functions) {
        super(weight, quality, conditions, functions);
    }

    public LootPoolEntryType getType() {
        return DTRegistries.SEED_ITEM.get();
    }

    protected void createItemStack(Consumer<ItemStack> stackConsumer, LootContext context) {
        Species species = (Species)context.getParamOrNull(DTLootContextParams.SPECIES);
        assert (species != null);
        stackConsumer.accept(species.shouldDropSeeds() ? species.getSeedStack(1) : ItemStack.EMPTY);
    }

    public static LootPoolSingletonContainer.Builder<?> lootTableSeedItem() {
        return SeedItemLootPoolEntry.simpleBuilder(SeedItemLootPoolEntry::new);
    }
}

