/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.loot.function;

import com.dtteam.dynamictrees.loot.DTLootContextParams;
import com.dtteam.dynamictrees.registry.DTRegistries;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public final class MultiplyByLogsCount
extends LootItemConditionalFunction {
    public static final MapCodec<MultiplyByLogsCount> CODEC = RecordCodecBuilder.mapCodec(instance -> MultiplyByLogsCount.commonFields((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, MultiplyByLogsCount::new));

    public MultiplyByLogsCount(List<LootItemCondition> conditions) {
        super(conditions);
    }

    public LootItemFunctionType<? extends LootItemConditionalFunction> getType() {
        return DTRegistries.MULTIPLY_LOGS_COUNT.get();
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        Integer volume = (Integer)context.getParamOrNull(DTLootContextParams.VOLUME);
        assert (volume != null);
        stack.setCount(stack.getCount() * (int)Math.floor((float)volume.intValue() / 4096.0f));
        return stack;
    }

    public static LootItemFunction.Builder multiplyByLogsCount() {
        return () -> new MultiplyByLogsCount(List.of());
    }
}

