/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.model.baked;

import com.dtteam.dynamictrees.model.ModelHelper;
import com.dtteam.dynamictrees.model.baked.BasicBranchBlockBakedModel;
import com.dtteam.dynamictrees.model.modeldata.ModelConnections;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.IModelBuilder;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class BasicRootsBlockBakedModel
extends BasicBranchBlockBakedModel {
    private static final int MIN_RADIUS_FOR_CROSS = 4;
    static final float Z_FIGHTING_OFFSET = 0.001f;
    private final BakedModel[][] sleeveEndFaces = new BakedModel[6][8];

    public BasicRootsBlockBakedModel(IGeometryBakingContext customData, ResourceLocation barkTextureLocation, ResourceLocation ringsTextureLocation, Function<Material, TextureAtlasSprite> spriteGetter) {
        super(customData, barkTextureLocation, ringsTextureLocation, spriteGetter);
        this.initModels();
    }

    private void initModels() {
        if (!this.isTransparent()) {
            for (int i = 0; i < 8; ++i) {
                int radius = i + 1;
                for (Direction dir : Direction.values()) {
                    this.sleeveEndFaces[dir.get3DDataValue()][i] = this.bakeSleeveFace(radius, dir, this.ringsTexture);
                }
            }
        }
    }

    @Override
    public BakedModel bakeSleeve(int radius, Direction dir, TextureAtlasSprite bark) {
        BlockElement part = this.generateSleevePart(radius, dir, false);
        IModelBuilder<?> builder = ModelHelper.getModelBuilder((IGeometryBakingContext)this.blockModel.customData, bark);
        for (Map.Entry e : part.faces.entrySet()) {
            Direction face = (Direction)e.getKey();
            builder.addCulledFace(face, ModelHelper.makeBakedQuad(part, (BlockElementFace)e.getValue(), bark, face, BlockModelRotation.X0_Y0));
        }
        if (this.isTransparent()) {
            BlockElement insidePart = this.generateSleevePart(radius, dir, true);
            for (Map.Entry e : insidePart.faces.entrySet()) {
                Direction face = (Direction)e.getKey();
                builder.addCulledFace(face, ModelHelper.makeBakedQuad(insidePart, (BlockElementFace)e.getValue(), bark, face.getOpposite(), BlockModelRotation.X0_Y0));
            }
            if (radius >= 4) {
                for (Direction.Axis axis : Direction.Axis.values()) {
                    if (axis == dir.getAxis()) continue;
                    BlockElement insideCross = this.generateSleeveAxisPlane(radius, axis, dir);
                    for (Map.Entry e : insideCross.faces.entrySet()) {
                        Direction face = (Direction)e.getKey();
                        builder.addCulledFace(face, ModelHelper.makeBakedQuad(insideCross, (BlockElementFace)e.getValue(), bark, face, BlockModelRotation.X0_Y0));
                    }
                }
            }
        }
        return builder.build();
    }

    public BlockElement generateSleeveAxisPlane(int radius, Direction.Axis axis, Direction dir) {
        Direction[] axisDirections = this.directionsOfAxis(axis);
        int dradius = radius * 2;
        int halfSize = (16 - dradius) / 2;
        int halfSizeX = dir.getStepX() != 0 ? halfSize : dradius;
        int halfSizeY = dir.getStepY() != 0 ? halfSize : dradius;
        int halfSizeZ = dir.getStepZ() != 0 ? halfSize : dradius;
        int move = 16 - halfSize;
        int centerX = 16 + dir.getStepX() * move;
        int centerY = 16 + dir.getStepY() * move;
        int centerZ = 16 + dir.getStepZ() * move;
        EnumMap mapFacesIn = Maps.newEnumMap(Direction.class);
        Vector3f posFrom = new Vector3f((float)(centerX - halfSizeX) / 2.0f, (float)(centerY - halfSizeY) / 2.0f, (float)(centerZ - halfSizeZ) / 2.0f);
        Vector3f posTo = new Vector3f((float)(centerX + halfSizeX) / 2.0f, (float)(centerY + halfSizeY) / 2.0f, (float)(centerZ + halfSizeZ) / 2.0f);
        if (axis == Direction.Axis.X) {
            posFrom = new Vector3f(8.0f, posFrom.y(), posFrom.z());
            posTo = new Vector3f(8.0f, posTo.y(), posTo.z());
        } else if (axis == Direction.Axis.Y) {
            posFrom = new Vector3f(posFrom.x(), 8.0f, posFrom.z());
            posTo = new Vector3f(posTo.x(), 8.0f, posTo.z());
        } else if (axis == Direction.Axis.Z) {
            posFrom = new Vector3f(posFrom.x(), posFrom.y(), 8.0f);
            posTo = new Vector3f(posTo.x(), posTo.y(), 8.0f);
        }
        for (Direction face : axisDirections) {
            boolean negative;
            boolean bl = negative = dir.getAxisDirection() == Direction.AxisDirection.NEGATIVE;
            if (dir.getAxis() == Direction.Axis.Z) {
                negative = !negative;
            }
            BlockFaceUV uvface = new BlockFaceUV(new float[]{8 - radius, negative ? (float)(16 - halfSize) : 0.0f, 8 + radius, negative ? 16.0f : (float)halfSize}, this.getFaceAngle(dir.getAxis(), face.getOpposite()));
            mapFacesIn.put(face, new BlockElementFace(null, -1, "", uvface));
        }
        return new BlockElement(posFrom, posTo, (Map)mapFacesIn, null, true);
    }

    @Override
    public BakedModel bakeCore(int radius, Direction.Axis coreAxis, TextureAtlasSprite icon) {
        IModelBuilder<?> builder = ModelHelper.getModelBuilder((IGeometryBakingContext)this.blockModel.customData, icon);
        BlockElement part = this.generateCorePart(radius, coreAxis, false);
        for (Map.Entry e : part.faces.entrySet()) {
            Direction face = (Direction)e.getKey();
            builder.addCulledFace(face, ModelHelper.makeBakedQuad(part, (BlockElementFace)e.getValue(), icon, face, BlockModelRotation.X0_Y0));
        }
        if (this.isTransparent()) {
            BlockElement insidePart = this.generateCorePart(radius, coreAxis, true);
            for (Map.Entry e : insidePart.faces.entrySet()) {
                Direction face = (Direction)e.getKey();
                builder.addCulledFace(face, ModelHelper.makeBakedQuad(insidePart, (BlockElementFace)e.getValue(), icon, face.getOpposite(), BlockModelRotation.X0_Y0));
            }
            if (radius >= 4 && icon != this.ringsTexture) {
                for (Direction.Axis planeAxis : Direction.Axis.values()) {
                    if (planeAxis == coreAxis) continue;
                    BlockElement insideCross = this.generateCoreAxisPlane(radius, planeAxis, coreAxis);
                    for (Map.Entry e : insideCross.faces.entrySet()) {
                        Direction face = (Direction)e.getKey();
                        builder.addUnculledFace(ModelHelper.makeBakedQuad(insideCross, (BlockElementFace)e.getValue(), icon, face, BlockModelRotation.X0_Y0));
                    }
                }
            }
        }
        return builder.build();
    }

    public BlockElement generateCoreAxisPlane(int radius, Direction.Axis planeAxis, Direction.Axis coreAxis) {
        Direction[] axisDirections = this.directionsOfAxis(planeAxis);
        EnumMap mapFacesIn = Maps.newEnumMap(Direction.class);
        Vector3f posFrom = new Vector3f((float)(8 - radius), (float)(8 - radius), (float)(8 - radius));
        Vector3f posTo = new Vector3f((float)(8 + radius), (float)(8 + radius), (float)(8 + radius));
        float center = 8.001f;
        if (planeAxis == Direction.Axis.X) {
            posFrom = new Vector3f(8.001f, posFrom.y(), posFrom.z());
            posTo = new Vector3f(8.001f, posTo.y(), posTo.z());
        } else if (planeAxis == Direction.Axis.Y) {
            posFrom = new Vector3f(posFrom.x(), 8.001f, posFrom.z());
            posTo = new Vector3f(posTo.x(), 8.001f, posTo.z());
        } else if (planeAxis == Direction.Axis.Z) {
            posFrom = new Vector3f(posFrom.x(), posFrom.y(), 8.001f);
            posTo = new Vector3f(posTo.x(), posTo.y(), 8.001f);
        }
        for (Direction face : axisDirections) {
            BlockFaceUV uvface = new BlockFaceUV(new float[]{8 - radius, 8 - radius, 8 + radius, 8 + radius}, this.getFaceAngle(coreAxis, face.getOpposite()));
            mapFacesIn.put(face, new BlockElementFace(null, -1, "", uvface));
        }
        return new BlockElement(posFrom, posTo, (Map)mapFacesIn, null, true);
    }

    public BakedModel bakeSleeveFace(int radius, Direction dir, TextureAtlasSprite rings) {
        int dradius = radius * 2;
        int halfSize = (16 - dradius) / 2;
        float halfSizeX = dir.getStepX() != 0 ? (float)halfSize + 0.001f : (float)dradius;
        float halfSizeY = dir.getStepY() != 0 ? (float)halfSize + 0.001f : (float)dradius;
        float halfSizeZ = dir.getStepZ() != 0 ? (float)halfSize + 0.001f : (float)dradius;
        int move = 16 - halfSize;
        int centerX = 16 + dir.getStepX() * move;
        int centerY = 16 + dir.getStepY() * move;
        int centerZ = 16 + dir.getStepZ() * move;
        Vector3f posFrom = new Vector3f(((float)centerX - halfSizeX) / 2.0f, ((float)centerY - halfSizeY) / 2.0f, ((float)centerZ - halfSizeZ) / 2.0f);
        Vector3f posTo = new Vector3f(((float)centerX + halfSizeX) / 2.0f, ((float)centerY + halfSizeY) / 2.0f, ((float)centerZ + halfSizeZ) / 2.0f);
        EnumMap mapFacesIn = Maps.newEnumMap(Direction.class);
        BlockFaceUV uvface = new BlockFaceUV(new float[]{8 - radius, 8 - radius, 8 + radius, 8 + radius}, 0);
        mapFacesIn.put(dir, new BlockElementFace(dir, -1, "", uvface));
        BlockElement part = new BlockElement(posFrom, posTo, (Map)mapFacesIn, null, true);
        IModelBuilder<?> builder = ModelHelper.getModelBuilder((IGeometryBakingContext)this.blockModel.customData, rings);
        for (Map.Entry e : part.faces.entrySet()) {
            Direction face = (Direction)e.getKey();
            builder.addCulledFace(face, ModelHelper.makeBakedQuad(part, (BlockElementFace)e.getValue(), rings, face, BlockModelRotation.X0_Y0));
        }
        return builder.build();
    }

    @Override
    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        if (state == null) {
            return Collections.emptyList();
        }
        int coreRadius = this.getRadius(state);
        if (coreRadius > 8) {
            return Collections.emptyList();
        }
        int[] connections = new int[]{0, 0, 0, 0, 0, 0};
        ModelConnections connectionsData = (ModelConnections)extraData.get(ModelConnections.CONNECTIONS_PROPERTY);
        if (connectionsData != null) {
            connections = connectionsData.getAllRadii();
        }
        if (side == null) {
            List<BakedQuad> quadsList = super.getQuads(state, null, rand, extraData, renderType);
            if (renderType == RenderType.solid()) {
                return quadsList;
            }
            Direction sourceDir = this.getSourceDir(coreRadius, connections);
            int coreDir = this.resolveCoreDir(sourceDir);
            quadsList.addAll(this.cores[coreDir][coreRadius - 1].getQuads(state, null, rand, extraData, renderType));
            return quadsList;
        }
        if (renderType != RenderType.solid()) {
            return Collections.emptyList();
        }
        ArrayList<BakedQuad> quadsList = new ArrayList<BakedQuad>(24);
        int idx = side.get3DDataValue();
        int connRadius = connections[idx];
        if (connRadius > 0) {
            quadsList.addAll(this.sleeveEndFaces[idx][connRadius - 1].getQuads(state, side, rand, extraData, renderType));
        }
        return quadsList;
    }

    private Direction[] directionsOfAxis(Direction.Axis axis) {
        return (Direction[])Arrays.stream(Direction.values()).filter(d -> d.getAxis() == axis).toList().toArray(Direction[]::new);
    }

    private boolean isTransparent() {
        return this.getRenderType() != RenderType.solid();
    }
}

