/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.model.baked;

import com.dtteam.dynamictrees.model.baked.PalmLeavesBakedModel;
import com.dtteam.dynamictrees.utility.CoordUtils;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MediumPalmLeavesBakedModel
extends PalmLeavesBakedModel {
    public static List<MediumPalmLeavesBakedModel> INSTANCES = new ArrayList<MediumPalmLeavesBakedModel>();

    public MediumPalmLeavesBakedModel(ResourceLocation frondsResLoc, Function<Material, TextureAtlasSprite> spriteGetter) {
        super(frondsResLoc, spriteGetter);
        INSTANCES.add(this);
    }

    @Override
    public void initModels() {
        for (CoordUtils.Surround surr : CoordUtils.Surround.values()) {
            SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(this.blockModel, ItemOverrides.EMPTY, false).particle(this.frondsTexture);
            PalmLeavesBakedModel.BlockVertexData[] quadData = new PalmLeavesBakedModel.BlockVertexData[]{new PalmLeavesBakedModel.BlockVertexData(0.0f, 0.0f, 3.0f, 0.9375f, 0.25f), new PalmLeavesBakedModel.BlockVertexData(0.0f, 1.0f, 3.0f, 0.9375f, 0.0f), new PalmLeavesBakedModel.BlockVertexData(0.0f, 1.0f, 0.0f, 0.0f, 0.0f), new PalmLeavesBakedModel.BlockVertexData(0.0f, 0.0f, 0.0f, 0.0f, 0.25f), new PalmLeavesBakedModel.BlockVertexData(0.0f, 0.0f, 3.0f, 0.9375f, 0.25f), new PalmLeavesBakedModel.BlockVertexData(0.0f, 0.0f, 0.0f, 0.0f, 0.25f), new PalmLeavesBakedModel.BlockVertexData(0.0f, 1.0f, 0.0f, 0.0f, 0.0f), new PalmLeavesBakedModel.BlockVertexData(0.0f, 1.0f, 3.0f, 0.9375f, 0.0f)};
            for (int pass = 0; pass < 3; ++pass) {
                for (int half = 0; half < 2; ++half) {
                    if (pass == 0 && surr.ordinal() % 2 != 0 || pass == 2 && surr.ordinal() % 2 == 0) continue;
                    PalmLeavesBakedModel.BlockVertexData[] outData = new PalmLeavesBakedModel.BlockVertexData[8];
                    for (int v = 0; v < 8; ++v) {
                        float x = quadData[v].x;
                        float z = quadData[v].z;
                        float y = quadData[v].y;
                        double len = 0.75 - (double)y;
                        double angle = Math.atan2(x *= 1.25f, y);
                        x = (float)(Math.sin(angle += Math.PI * (half == 1 ? 1.2 : -1.2)) * len);
                        y = (float)(Math.cos(angle) * len);
                        len = Math.sqrt(y * y + (z *= 1.25f) * z);
                        angle = Math.atan2(y, z);
                        y = (float)(Math.sin(angle += Math.PI * (pass == 2 ? 0.28 : (pass == 1 ? 0.06 : -0.17))) * len);
                        z = (float)(Math.cos(angle) * len);
                        len = Math.sqrt(x * x + z * z);
                        angle = Math.atan2(x, z);
                        x = (float)(Math.sin(angle += 0.7853981633974483 * (double)surr.ordinal() + Math.PI * (pass == 1 ? -0.065 : (pass == 2 ? 0.08 : 0.005))) * len);
                        z = (float)(Math.cos(angle) * len);
                        x += 0.5f;
                        z += 0.5f;
                        y = (float)((double)y + (pass == 2 ? -0.125 : (pass == 0 ? 0.125 : 0.0)));
                        outData[v] = new PalmLeavesBakedModel.BlockVertexData(x += (float)surr.getOffset().getX(), y, z += (float)surr.getOffset().getZ(), quadData[v].u, quadData[v].v);
                    }
                    int[] vertices = Ints.concat((int[][])new int[][]{outData[0].toInts(this.frondsTexture), outData[1].toInts(this.frondsTexture), outData[2].toInts(this.frondsTexture), outData[3].toInts(this.frondsTexture)});
                    builder.addUnculledFace(new BakedQuad(vertices, 0, FaceBakery.calculateFacing((int[])vertices), this.frondsTexture, true));
                    vertices = Ints.concat((int[][])new int[][]{outData[4].toInts(this.frondsTexture), outData[5].toInts(this.frondsTexture), outData[6].toInts(this.frondsTexture), outData[7].toInts(this.frondsTexture)});
                    builder.addUnculledFace(new BakedQuad(vertices, 0, FaceBakery.calculateFacing((int[])vertices), this.frondsTexture, true));
                    this.bakedFronds[surr.ordinal()] = builder.build(this.renderGroup);
                }
            }
        }
    }
}

