/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.model.loader;

import com.dtteam.dynamictrees.model.geometry.PalmLeavesModelGeometry;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class PalmLeavesModelLoader
implements IGeometryLoader<PalmLeavesModelGeometry> {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final String FROND = "frond";
    private static final String TEXTURES = "textures";
    private final int frondType;

    public PalmLeavesModelLoader(int type) {
        this.frondType = type;
    }

    public PalmLeavesModelGeometry read(JsonObject modelObject, JsonDeserializationContext deserializationContext) {
        JsonObject textures = this.getTexturesObject(modelObject);
        return new PalmLeavesModelGeometry(this.getTextureLocation(textures, FROND), this.frondType);
    }

    protected ResourceLocation getTextureLocation(JsonObject textureObject, String textureElement) {
        try {
            return this.getResLocOrThrow(this.getOrThrow(textureObject, textureElement));
        }
        catch (RuntimeException e) {
            LOGGER.error("{} missing or did not have valid \"{}\" texture location element, using missing texture.", (Object)this.getModelTypeName(), (Object)textureElement);
            return MissingTextureAtlasSprite.getLocation();
        }
    }

    protected JsonObject getTexturesObject(JsonObject modelContents) {
        if (!modelContents.has(TEXTURES) || !modelContents.get(TEXTURES).isJsonObject()) {
            this.throwRequiresElement(TEXTURES, "Json Object");
        }
        return modelContents.getAsJsonObject(TEXTURES);
    }

    protected ResourceLocation getResLocOrThrow(String resLocStr) {
        try {
            return ResourceLocation.parse((String)resLocStr);
        }
        catch (ResourceLocationException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getOrThrow(JsonObject jsonObject, String identifier) {
        if (jsonObject.get(identifier) == null || !jsonObject.get(identifier).isJsonPrimitive() || !jsonObject.get(identifier).getAsJsonPrimitive().isString()) {
            this.throwRequiresElement(identifier, "String");
        }
        return jsonObject.get(identifier).getAsString();
    }

    protected void throwRequiresElement(String element, String expectedType) {
        throw new RuntimeException(this.getModelTypeName() + " requires a valid \"" + element + "\" element of type " + expectedType + ".");
    }

    protected String getModelTypeName() {
        return "Palm Fronds";
    }
}

