/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.platform;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.platform.services.ICompatHelper;
import com.dtteam.dynamictrees.platform.services.IConfigHelper;
import com.dtteam.dynamictrees.platform.services.IEventHelper;
import com.dtteam.dynamictrees.platform.services.IInteractionHelper;
import com.dtteam.dynamictrees.platform.services.IMiscHelper;
import com.dtteam.dynamictrees.platform.services.IPlatformHelper;
import com.dtteam.dynamictrees.platform.services.IRegistryHelper;
import java.util.ServiceLoader;

public class Services {
    public static final IPlatformHelper PLATFORM = Services.load(IPlatformHelper.class);
    public static final IRegistryHelper REGISTRY = Services.load(IRegistryHelper.class);
    public static final IConfigHelper CONFIG = Services.load(IConfigHelper.class);
    public static final IInteractionHelper INTERACTION = Services.load(IInteractionHelper.class);
    public static final IMiscHelper MISC = Services.load(IMiscHelper.class);
    public static final ICompatHelper COMPAT = Services.load(ICompatHelper.class);
    public static final IEventHelper EVENT = Services.load(IEventHelper.class);

    public static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        DynamicTrees.LOG.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }
}

