/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.recipe;

import com.dtteam.dynamictrees.item.DendroPotion;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.recipe.DendroBrewingRecipe;
import com.dtteam.dynamictrees.registry.DTRegistries;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;

public class DendroPotionRecipeHandler {
    private static final List<DendroBrewingRecipe> brewingRecipes = new ArrayList<DendroBrewingRecipe>();

    public static List<DendroBrewingRecipe> getAllDendroRecipes() {
        if (!brewingRecipes.isEmpty()) {
            return brewingRecipes;
        }
        ItemStack baseStack = DendroPotionRecipeHandler.setPotion(new ItemStack((ItemLike)Items.POTION), Services.CONFIG.getStringConfig("biocharBrewingBase"));
        brewingRecipes.add(DendroPotionRecipeHandler.getRecipe(baseStack, new ItemStack((ItemLike)Items.CHARCOAL), DendroPotionRecipeHandler.getPotionStack(DendroPotion.DendroPotionType.BIOCHAR)));
        for (int i = 1; i < DendroPotion.DendroPotionType.values().length; ++i) {
            DendroPotion.DendroPotionType type = DendroPotion.DendroPotionType.values()[i];
            if (!type.isActive()) continue;
            brewingRecipes.add(DendroPotionRecipeHandler.getRecipe(type.getIngredient(), type));
        }
        return brewingRecipes;
    }

    public static ItemStack setPotion(ItemStack pStack, String potionName) {
        Optional potion = BuiltInRegistries.POTION.getHolder(ResourceKey.create((ResourceKey)Registries.POTION, (ResourceLocation)ResourceLocation.parse((String)potionName)));
        potion.ifPresent(holder -> pStack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents((Holder)holder)));
        return pStack;
    }

    private static DendroBrewingRecipe getRecipe(ItemStack ingredient, DendroPotion.DendroPotionType typeOut) {
        return DendroPotionRecipeHandler.getRecipe(DendroPotionRecipeHandler.getPotionStack(typeOut.getBasePotionType()), ingredient, DendroPotionRecipeHandler.getPotionStack(typeOut));
    }

    private static DendroBrewingRecipe getRecipe(ItemStack stackIn, ItemStack ingredientStack, ItemStack stackOut) {
        return new DendroBrewingRecipe(stackIn, ingredientStack, stackOut);
    }

    private static ItemStack getPotionStack(DendroPotion.DendroPotionType type) {
        return DendroPotion.applyIndexTag(new ItemStack((ItemLike)DTRegistries.DENDRO_POTION.get()), type.getIndex());
    }
}

