/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems;

import com.dtteam.dynamictrees.block.FutureBreakable;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class FutureBreak {
    public static final List<FutureBreak> FUTURE_BREAKS = new LinkedList<FutureBreak>();
    public final BlockState state;
    public final Level level;
    public final BlockPos pos;
    public final LivingEntity entity;
    public int ticks;

    public FutureBreak(BlockState state, Level level, BlockPos pos, LivingEntity entity, int ticks) {
        this.state = state;
        this.level = level;
        this.pos = pos;
        this.entity = entity;
        this.ticks = ticks;
    }

    public static void add(FutureBreak fb) {
        if (!fb.level.isClientSide) {
            FUTURE_BREAKS.add(fb);
        }
    }

    public static void process(Level level) {
        if (FUTURE_BREAKS.isEmpty()) {
            return;
        }
        for (FutureBreak futureBreak : new LinkedList<FutureBreak>(FUTURE_BREAKS)) {
            if (level != futureBreak.level) continue;
            Block block = futureBreak.state.getBlock();
            if (!(block instanceof FutureBreakable)) {
                FUTURE_BREAKS.remove(futureBreak);
                continue;
            }
            FutureBreakable futureBreakable = (FutureBreakable)block;
            if (futureBreak.ticks-- > 0) continue;
            futureBreakable.futureBreak(futureBreak.state, level, futureBreak.pos, futureBreak.entity);
            FUTURE_BREAKS.remove(futureBreak);
        }
    }
}

