/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.genfeature;

import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.api.network.MapSignal;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.fruit.Fruit;
import com.dtteam.dynamictrees.systems.genfeature.GenFeature;
import com.dtteam.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.dtteam.dynamictrees.systems.nodemapper.FindEndsNode;
import com.dtteam.dynamictrees.systems.season.SeasonHelper;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.utility.CoordUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class FruitGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Fruit> FRUIT = ConfigurationProperty.property("fruit", Fruit.class);

    public FruitGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(FRUIT, VERTICAL_SPREAD, QUANTITY, RAY_DISTANCE, FRUITING_RADIUS, PLACE_CHANCE);
    }

    @Override
    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(FRUIT, Fruit.NULL)).with(VERTICAL_SPREAD, Float.valueOf(30.0f))).with(QUANTITY, 4)).with(FRUITING_RADIUS, 8)).with(PLACE_CHANCE, Float.valueOf(1.0f));
    }

    @Override
    public boolean shouldApply(Species species, GenFeatureConfiguration configuration) {
        return species.hasFruit(configuration.get(FRUIT));
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        if (!context.endPoints().isEmpty()) {
            int qty = (Integer)configuration.get(QUANTITY);
            qty = (int)((float)qty * context.fruitProductionFactor().floatValue());
            for (int i = 0; i < qty; ++i) {
                BlockPos endPoint = context.endPoints().get(context.random().nextInt(context.endPoints().size()));
                this.placeDuringWorldGen(configuration, context.species(), context.level(), context.pos().above(), endPoint, context.isWorldGen(), context.seasonValue());
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        LevelAccessor level = context.level();
        BlockState blockState = level.getBlockState(context.treePos());
        BranchBlock branch = TreeHelper.getBranch(blockState);
        Fruit fruit = configuration.get(FRUIT);
        if (branch != null && branch.getRadius(blockState) >= (Integer)configuration.get(FRUITING_RADIUS) && context.natural()) {
            BlockPos rootPos = context.pos();
            float fruitingFactor = fruit.seasonalFruitProductionFactor(context.levelContext(), rootPos).floatValue();
            if (fruitingFactor > fruit.getRequiredProductionFactor() && fruitingFactor > level.getRandom().nextFloat()) {
                FindEndsNode endFinder = new FindEndsNode();
                TreeHelper.startAnalysisFromRoot(level, rootPos, new MapSignal(endFinder));
                List<BlockPos> endPoints = endFinder.getEnds();
                int qty = (Integer)configuration.get(QUANTITY);
                if (!endPoints.isEmpty()) {
                    for (int i = 0; i < qty; ++i) {
                        BlockPos endPoint = endPoints.get(level.getRandom().nextInt(endPoints.size()));
                        this.place(configuration, context.species(), level, rootPos.above(), endPoint, SeasonHelper.getSeasonValue(context.levelContext(), rootPos));
                    }
                }
            }
        }
        return true;
    }

    protected void place(GenFeatureConfiguration configuration, Species species, LevelAccessor level, BlockPos treePos, BlockPos branchPos, Float seasonValue) {
        BlockPos fruitPos = CoordUtils.getRayTraceFruitPos(level, species, treePos, branchPos, false);
        if (this.shouldPlace(configuration, level, fruitPos)) {
            configuration.get(FRUIT).place(level, fruitPos, seasonValue);
        }
    }

    protected boolean shouldPlace(GenFeatureConfiguration configuration, LevelAccessor level, BlockPos pos) {
        return pos != BlockPos.ZERO && (CoordUtils.coordHashCode(pos, 0) & 3) == 0 && level.getRandom().nextFloat() <= ((Float)configuration.get(PLACE_CHANCE)).floatValue();
    }

    protected void placeDuringWorldGen(GenFeatureConfiguration configuration, Species species, LevelAccessor level, BlockPos treePos, BlockPos branchPos, boolean worldGen, Float seasonValue) {
        BlockPos fruitPos = CoordUtils.getRayTraceFruitPos(level, species, treePos, branchPos, worldGen);
        if (this.shouldPlaceDuringWorldGen(configuration, level, fruitPos)) {
            configuration.get(FRUIT).placeDuringWorldGen(level, fruitPos, seasonValue);
        }
    }

    protected boolean shouldPlaceDuringWorldGen(GenFeatureConfiguration configuration, LevelAccessor level, BlockPos pos) {
        return pos != BlockPos.ZERO && level.getRandom().nextFloat() <= ((Float)configuration.get(PLACE_CHANCE)).floatValue();
    }
}

