/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.genfeature;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.api.configuration.ConfigurableRegistry;
import com.dtteam.dynamictrees.api.configuration.ConfigurableRegistryEntry;
import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.api.worldgen.BiomePredicate;
import com.dtteam.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.dtteam.dynamictrees.systems.genfeature.context.FullGenerationContext;
import com.dtteam.dynamictrees.systems.genfeature.context.GenFeatureContext;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.dtteam.dynamictrees.systems.genfeature.context.PostRotContext;
import com.dtteam.dynamictrees.systems.genfeature.context.PreGenerationContext;
import com.dtteam.dynamictrees.tree.species.Species;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import org.apache.commons.lang3.function.TriFunction;

public abstract class GenFeature
extends ConfigurableRegistryEntry<GenFeature, GenFeatureConfiguration> {
    public static final ConfigurationProperty<Float> VERTICAL_SPREAD = ConfigurationProperty.floatProperty("vertical_spread");
    public static final ConfigurationProperty<Integer> QUANTITY = ConfigurationProperty.integer("quantity");
    public static final ConfigurationProperty<Float> RAY_DISTANCE = ConfigurationProperty.floatProperty("ray_distance");
    public static final ConfigurationProperty<Integer> MAX_HEIGHT = ConfigurationProperty.integer("max_height");
    public static final ConfigurationProperty<CanGrowPredicate> CAN_GROW_PREDICATE = ConfigurationProperty.property("can_grow_predicate", CanGrowPredicate.class);
    public static final ConfigurationProperty<Integer> MAX_COUNT = ConfigurationProperty.integer("max_count");
    public static final ConfigurationProperty<Integer> FRUITING_RADIUS = ConfigurationProperty.integer("fruiting_radius");
    public static final ConfigurationProperty<Float> PLACE_CHANCE = ConfigurationProperty.floatProperty("place_chance");
    public static final ConfigurationProperty<BiomePredicate> BIOME_PREDICATE = ConfigurationProperty.property("biome_predicate", BiomePredicate.class);
    public static final GenFeature NULL = new GenFeature(DynamicTrees.NULL){

        @Override
        protected void registerProperties() {
        }

        @Override
        public GenFeatureConfiguration getDefaultConfiguration() {
            return (GenFeatureConfiguration)this.defaultConfiguration;
        }
    };
    public static final ConfigurableRegistry<GenFeature, GenFeatureConfiguration> REGISTRY = new ConfigurableRegistry<GenFeature, GenFeatureConfiguration>(GenFeature.class, NULL, GenFeatureConfiguration.TEMPLATES);

    public GenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected GenFeatureConfiguration createDefaultConfiguration() {
        return new GenFeatureConfiguration(this);
    }

    public <C extends GenFeatureContext, R> R generate(GenFeatureConfiguration configuration, Type<C, R> type, C context) {
        return type.generate(configuration, context);
    }

    protected BlockPos preGenerate(GenFeatureConfiguration configuration, PreGenerationContext context) {
        return context.pos();
    }

    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        return true;
    }

    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        return true;
    }

    protected boolean postRot(GenFeatureConfiguration configuration, PostRotContext context) {
        return true;
    }

    protected boolean generate(GenFeatureConfiguration configuration, FullGenerationContext context) {
        return false;
    }

    public boolean shouldApply(Species species, GenFeatureConfiguration configuration) {
        return true;
    }

    public static final class Type<C extends GenFeatureContext, R> {
        public static final Type<PreGenerationContext, BlockPos> PRE_GENERATION = new Type(GenFeature::preGenerate);
        public static final Type<PostGenerationContext, Boolean> POST_GENERATION = new Type(GenFeature::postGenerate);
        public static final Type<PostGrowContext, Boolean> POST_GROW = new Type(GenFeature::postGrow);
        public static final Type<PostRotContext, Boolean> POST_ROT = new Type(GenFeature::postRot);
        public static final Type<FullGenerationContext, Boolean> FULL = new Type(GenFeature::generate);
        private final TriFunction<GenFeature, GenFeatureConfiguration, C, R> generateConsumer;

        public Type(TriFunction<GenFeature, GenFeatureConfiguration, C, R> generateConsumer) {
            this.generateConsumer = generateConsumer;
        }

        public R generate(GenFeatureConfiguration configuration, C context) {
            return (R)this.generateConsumer.apply((Object)configuration.getGenFeature(), (Object)configuration, context);
        }
    }

    @FunctionalInterface
    public static interface CanGrowPredicate
    extends BiPredicate<LevelAccessor, BlockPos> {
    }
}

