/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.genfeature;

import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.api.network.MapSignal;
import com.dtteam.dynamictrees.block.soil.SoilBlock;
import com.dtteam.dynamictrees.block.soil.SoilHelper;
import com.dtteam.dynamictrees.data.tags.DTBlockTags;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.systems.genfeature.GenFeature;
import com.dtteam.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.dtteam.dynamictrees.systems.nodemapper.FindEndsNode;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.utility.CoordUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockState;

public class PodzolGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Block> PODZOL_BLOCK = ConfigurationProperty.block("podzol_block");
    public static final ConfigurationProperty<Integer> SPREAD_DISTANCE = ConfigurationProperty.integer("spread_distance");
    public static final ConfigurationProperty<Integer> DARK_THRESHOLD = ConfigurationProperty.integer("dark_threshold");
    public static final ConfigurationProperty<Integer> MAX_HEIGHT = ConfigurationProperty.integer("max_height");
    public static final ConfigurationProperty<Boolean> KILL_PLANTS = ConfigurationProperty.bool("kill_plants");

    public PodzolGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(KILL_PLANTS, DARK_THRESHOLD, SPREAD_DISTANCE, PODZOL_BLOCK, MAX_HEIGHT);
    }

    @Override
    protected GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(KILL_PLANTS, false)).with(DARK_THRESHOLD, 10)).with(SPREAD_DISTANCE, 2)).with(PODZOL_BLOCK, Blocks.PODZOL)).with(MAX_HEIGHT, 32);
    }

    @Override
    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        if (!Services.CONFIG.getBoolConfig("generatePodzol").booleanValue()) {
            return false;
        }
        LevelAccessor level = context.level();
        FindEndsNode endFinder = new FindEndsNode();
        TreeHelper.startAnalysisFromRoot(level, context.pos(), new MapSignal(endFinder));
        List<BlockPos> endPoints = endFinder.getEnds();
        if (endPoints.isEmpty()) {
            return false;
        }
        RandomSource random = context.random();
        BlockPos pos = endPoints.get(random.nextInt(endPoints.size()));
        int distance = configuration.get(SPREAD_DISTANCE);
        int x = pos.getX() + random.nextInt(distance * 2 + 1) - distance;
        int z = pos.getZ() + random.nextInt(distance * 2 + 1) - distance;
        int darkThreshold = configuration.get(DARK_THRESHOLD);
        Block podzol = configuration.get(PODZOL_BLOCK);
        int maxHeight = configuration.get(MAX_HEIGHT);
        for (int i = 0; i < maxHeight; ++i) {
            BlockPos offPos = new BlockPos(x, pos.getY() - 1 - i, z);
            if (level.isEmptyBlock(offPos)) continue;
            BlockState state = level.getBlockState(offPos);
            if (TreeHelper.isRooty(state)) break;
            if (configuration.get(KILL_PLANTS).booleanValue() && this.shouldDestroyPlant(state)) {
                if (level.getBrightness(LightLayer.SKY, offPos) > darkThreshold) continue;
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                continue;
            }
            if (state.is(DTBlockTags.FOLIAGE) || TreeHelper.isTreePart(state)) continue;
            if (!SoilHelper.isSoilAcceptable(state, SoilHelper.getSoilFlags("dirt_like"))) break;
            if (level.getBrightness(LightLayer.SKY, offPos.above()) <= darkThreshold) {
                level.setBlock(offPos, podzol.defaultBlockState(), 3);
                break;
            }
            PodzolGenFeature.spreadPodzol(level, pos, podzol);
            break;
        }
        return true;
    }

    private boolean shouldDestroyPlant(BlockState state) {
        Block block = state.getBlock();
        return block instanceof FlowerBlock || block instanceof TallGrassBlock || block instanceof DoublePlantBlock;
    }

    public static void spreadPodzol(LevelAccessor level, BlockPos pos, Block podzol) {
        int podzolish = 0;
        for (Direction dir : CoordUtils.HORIZONTALS) {
            BlockPos deltaPos = pos.relative(dir);
            Block testBlock = level.getBlockState(deltaPos).getBlock();
            podzolish += testBlock == podzol ? 1 : 0;
            if ((podzolish += testBlock instanceof SoilBlock ? 1 : 0) < 3) continue;
            level.setBlock(pos, podzol.defaultBlockState(), 3);
            break;
        }
    }
}

