/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.genfeature;

import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.api.worldgen.LevelContext;
import com.dtteam.dynamictrees.systems.genfeature.GenFeature;
import com.dtteam.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.utility.CoordUtils;
import com.dtteam.dynamictrees.worldgen.DynamicTreeGenerationContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;

public class UndergrowthGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Species> SPECIES_A = ConfigurationProperty.property("undergrowth_species", Species.class);
    public static final ConfigurationProperty<Species> SPECIES_B = ConfigurationProperty.property("secondary_undergrowth_species", Species.class);
    public static final ConfigurationProperty<Float> PROPORTION = ConfigurationProperty.floatProperty("proportion_of_secondary_species");
    int checkDown = -1;
    int checkUp = 4;

    public UndergrowthGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(SPECIES_A, SPECIES_B, PROPORTION);
    }

    @Override
    protected GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(SPECIES_A, Species.NULL_SPECIES)).with(SPECIES_B, Species.NULL_SPECIES)).with(PROPORTION, Float.valueOf(0.4f));
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        return this.tryToPlaceTree(configuration, context.levelContext(), context.level(), context.pos(), context.radius());
    }

    private boolean tryToPlaceTree(GenFeatureConfiguration config, LevelContext levelContext, LevelAccessor level, BlockPos rootPos, int radius) {
        if (radius <= 2) {
            return false;
        }
        Vec3 vTree = new Vec3((double)rootPos.getX(), (double)rootPos.getY(), (double)rootPos.getZ()).add(0.5, 0.5, 0.5);
        int placedBushes = 0;
        for (int attempts = 0; placedBushes <= 2 && attempts <= 10; ++attempts) {
            Species species;
            int rad = Mth.clamp((int)(level.getRandom().nextInt(radius - 2) + 2), (int)2, (int)(radius - 1));
            Vec3 v = vTree.add(new Vec3(1.0, 0.0, 0.0).scale((double)rad).yRot((float)((double)level.getRandom().nextFloat() * Math.PI * 2.0)));
            BlockPos vPos = BlockPos.containing((Position)v);
            BlockPos groundPos = CoordUtils.findWorldSurface(level, vPos, true);
            if (this.areTreesAround(level, groundPos)) continue;
            Species species2 = species = level.getRandom().nextFloat() < config.get(PROPORTION).floatValue() ? config.get(SPECIES_B) : config.get(SPECIES_A);
            if (!this.placeTreeAtLocation(levelContext, groundPos, species)) continue;
            ++placedBushes;
        }
        return placedBushes > 0;
    }

    private boolean areTreesAround(LevelAccessor world, BlockPos rootPos) {
        for (int i = this.checkDown; i <= this.checkUp; ++i) {
            for (CoordUtils.Surround dir : CoordUtils.Surround.values()) {
                BlockPos offsetPos = rootPos.offset(dir.getOffset()).above(i);
                if (!TreeHelper.isBranch(world.getBlockState(offsetPos))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean placeTreeAtLocation(LevelContext levelContext, BlockPos newRootPos, Species species) {
        LevelAccessor level = levelContext.accessor();
        for (int i = 1; i >= -1; --i) {
            BlockPos offsetRootPos = newRootPos.above(i);
            if (!species.isAcceptableSoil(level.getBlockState(offsetRootPos))) continue;
            if (level instanceof WorldGenRegion) {
                WorldGenRegion worldGenRegion = (WorldGenRegion)level;
                species.generate(new DynamicTreeGenerationContext(levelContext, species, offsetRootPos, offsetRootPos.mutable(), (Holder<Biome>)worldGenRegion.getBiome(offsetRootPos), Direction.Plane.HORIZONTAL.getRandomDirection(level.getRandom()), 2, true));
            }
            return true;
        }
        return false;
    }
}

