/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.nodemapper;

import com.dtteam.dynamictrees.api.network.NodeInspector;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.species.Species;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class FreezerNode
implements NodeInspector {
    private final Species species;
    private static final int freezeRadius = 3;

    public FreezerNode(Species species) {
        this.species = species;
    }

    @Override
    public boolean run(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir) {
        int radius;
        BranchBlock branch = TreeHelper.getBranch(state);
        if (branch != null && (radius = branch.getRadius(state)) == 1) {
            this.freezeSurroundingLeaves(level, branch, pos);
        }
        return true;
    }

    @Override
    public boolean returnRun(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir) {
        return false;
    }

    public void freezeSurroundingLeaves(LevelAccessor world, BranchBlock branch, BlockPos twigPos) {
        if (world.isClientSide()) {
            return;
        }
        Family tree = branch.getFamily();
        BlockPos.betweenClosedStream((BlockPos)twigPos.offset(-3, -3, -3), (BlockPos)twigPos.offset(3, 3, 3)).forEach(leavesPos -> {
            if (!tree.isCompatibleGenericLeaves(this.species, world.getBlockState(leavesPos), world, (BlockPos)leavesPos)) {
                return;
            }
            BlockState state = world.getBlockState(leavesPos);
            DynamicLeavesBlock leaves = TreeHelper.getLeaves(state);
            if (leaves == null) {
                return;
            }
            world.setBlock(leavesPos, (BlockState)leaves.getLeavesProperties().getPrimitiveLeaves().setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true)), 2);
        });
    }
}

